/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.b2c.order.scheduled;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yunxi.dg.base.center.trade.constants.DgConsignTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderStatusEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderLabelBaseRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsOrderHandleService;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.common.DgB2CConsumerAround;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.constant.DgB2COrderMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.execute.DgB2COrderStatemachineExecutor;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"cis.statemachine.oms.config.enable"}, havingValue="true")
@Component
public class DgRetryAutoSourceScheduled {
    private static final Logger LOGGER = LoggerFactory.getLogger(DgRetryAutoSourceScheduled.class);
    private static final String AUTO_SOURCE_PREEMPT_KEY = "AUTO_SOURCE_PREEMPT_KEY";
    private static final String AUTO_RETRY_KEY = "AUTO_RETRY_KEY";
    @Resource
    private ICacheService cacheService;
    @Resource
    private IDgOrderLabelItemDomain orderLabelItemDomain;
    @Resource
    private DgB2COrderStatemachineExecutor dgB2COrderStatemachineExecutor;
    @Resource
    private IDgPerformOrderInfoDomain performOrderInfoDomain;
    @Resource
    private IDgOmsOrderHandleService dgOmsOrderHandleService;

    @Scheduled(cron="${oms.scheduled.auto.source.time:0 0 0/3 * * ? }")
    public void autoSourceAndPreempt() {
        CompletableFuture.runAsync(() -> {
            String requestId = RequestId.createReqId();
            MDC.put((String)"yes.req.requestId", (String)requestId);
            ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
            LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u7f3a\u8d27\u91cd\u65b0\u5360\u5355]\u5b9a\u65f6\u5668\u5f00\u59cb\u6267\u884c\u81ea\u52a8\u7f3a\u8d27\u91cd\u65b0\u5360\u5355\u4efb\u52a1!");
            LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u7f3a\u8d27\u91cd\u65b0\u5360\u5355]\u5b9a\u65f6\u5668\u542f\u52a8");
            try {
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.cacheService.getCache(AUTO_RETRY_KEY, String.class)))) {
                    LOGGER.info("\u5df2\u7ecf\u6709\u5b9a\u65f6\u5668\u5728\u6267\u884c\u81ea\u52a8\u7f3a\u8d27\u91cd\u65b0\u5360\u5355\u4efb\u52a1,\u4e0d\u9700\u8981\u91cd\u590d\u6267\u884c");
                    return;
                }
                this.cacheService.setCache(AUTO_RETRY_KEY, (Object)"1");
                this.handleAutoSourceAndPreempt();
            }
            catch (Exception e) {
                LOGGER.error("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u7f3a\u8d27\u91cd\u65b0\u5360\u5355]\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
            }
            finally {
                this.cacheService.delCache(AUTO_RETRY_KEY);
            }
            LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u7f3a\u8d27\u91cd\u65b0\u5360\u5355]\u5b9a\u65f6\u5668\u4efb\u52a1\u6267\u884c\u5b8c\u6210!");
        });
    }

    private void handleAutoSourceAndPreempt() {
        DateTimeFormatter formatter;
        LocalDate today = LocalDate.now();
        LocalDate qiDaysAgo = today.minusDays(2L);
        String startTime = qiDaysAgo.format(formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        List orderLabelItemRespDtos = this.orderLabelItemDomain.queryItemLackLabel(DgOrderLabelEnum.ITEM_LACK, startTime);
        if (CollectionUtils.isEmpty((Collection)orderLabelItemRespDtos)) {
            LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u7f3a\u8d27\u91cd\u65b0\u5360\u5355]\u76ee\u524d\u4e0d\u5b58\u5728\u7f3a\u8d27\u7684\u8ba2\u5355!");
            return;
        }
        List orderIdList = orderLabelItemRespDtos.stream().map(DgOrderLabelBaseRespDto::getOrderId).distinct().collect(Collectors.toList());
        List saleOrderRespDtoList = this.performOrderInfoDomain.queryListByOrderIds(orderIdList);
        List retrySaleOrderList = saleOrderRespDtoList.stream().filter(saleOrderRespDto -> DgSaleOrderStatusEnum.LACK.getCode().equals(saleOrderRespDto.getOrderStatus())).collect(Collectors.toList());
        LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u7f3a\u8d27\u91cd\u65b0\u5360\u5355]\u5b58\u5728\u7f3a\u8d27\u7684\u8ba2\u5355\u6709\uff1a{}\u6761", (Object)retrySaleOrderList.size());
        for (DgPerformOrderInfoEo performOrderInfoEo : retrySaleOrderList) {
            LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u7f3a\u8d27\u91cd\u65b0\u5360\u5355]\u8ba2\u5355saleOrderNo={}\u5f00\u59cb\u91cd\u8bd5\u81ea\u52a8\u5bfb\u6e90\u53ca\u5360\u5355\u64cd\u4f5c!", (Object)performOrderInfoEo.getSaleOrderNo());
            try {
                DgB2CConsumerAround.aroundMessageConsumer(performOrderInfoEo, o -> "job", o -> "RETRY_AUTO_SOURCE_SCHEDULED", o -> String.format("\u7cfb\u7edf%s\u6267\u884c", "\u7f3a\u8d27\u81ea\u52a8\u91cd\u65b0\u5360\u5355"), o -> "PERFORM_ORDER", eo -> eo.getId().toString(), eo -> {
                    try {
                        if (Objects.equals(performOrderInfoEo.getConsignType(), DgConsignTypeEnum.THIRD.getType())) {
                            this.dgOmsOrderHandleService.modifySameSpecSku(performOrderInfoEo);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("\u5b9a\u65f6\u4efb\u52a1\u5e73\u53f0\u4ed3\u81ea\u52a8\u6362\u5546\u54c1\u5bfb\u6e90\u9519\u8bef", (Throwable)e);
                    }
                    this.dgB2COrderStatemachineExecutor.executeStatemachine(DgPerformOrderBizModelEnum.enumOf((String)eo.getBizModel()).getCode(), eo.getId(), null, (Object)DgB2COrderMachineEvents.AUTO_SOURCE_TRIGGER);
                    return MessageResponse.SUCCESS;
                });
                Thread.sleep(50L);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

