/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.f2b.order.config.engine.action;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.statemachine.engine.action.AbstractCisBaseStatemachineAction;
import com.dtyunxi.cube.statemachine.engine.action.CisActionDefine;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformNoticeSyncRecordItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.ChannelOptB2BOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.enums.ItemLineDeliveryStatusEnum;
import com.yunxi.dg.base.center.trade.statemachine.b2b.order.constant.DgB2BOrderMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.b2b.order.constant.DgB2BOrderStatus;
import com.yunxi.dg.base.center.trade.statemachine.b2b.order.execute.DgB2BOrderStatemachineExecutor;
import com.yunxi.dg.base.center.trade.statemachine.f2b.order.constant.DgF2BOrderActionDefineEnum;
import com.yunxi.dg.base.center.trade.statemachine.f2b.order.constant.DgF2BOrderMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.f2b.order.constant.DgF2BOrderMachineStatus;
import com.yunxi.dg.base.center.trade.statemachine.f2b.order.vo.DgF2BOrderThroughRespDto;
import com.yunxi.dg.base.commons.dto.BaseDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DgF2BInvalidB2bOrderAction
extends AbstractCisBaseStatemachineAction<DgF2BOrderActionDefineEnum, DgF2BOrderMachineStatus, DgF2BOrderMachineEvents, Object, ChannelOptB2BOrderRespDto, DgF2BOrderThroughRespDto> {
    private static final Logger log = LoggerFactory.getLogger(DgF2BInvalidB2bOrderAction.class);
    private List<String> allowOptOrderStatus = Lists.newArrayList((Object[])new String[]{DgB2BOrderStatus.WAIT_CHECK.getCode(), DgB2BOrderStatus.WAIT_PICK.getCode(), DgB2BOrderStatus.PICKED.getCode(), DgB2BOrderStatus.WAIT_DELIVERY.getCode()});
    @Resource
    private DgB2BOrderStatemachineExecutor dgB2BOrderStatemachineExecutor;
    @Resource
    private IDgPerformNoticeSyncRecordItemDomain dgPerformNoticeSyncRecordItemDomain;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgPerformOrderItemLineDomain performOrderItemLineDomain;

    public DgF2BInvalidB2bOrderAction() {
        super((CisActionDefine)DgF2BOrderActionDefineEnum.CHANNEL_INVALID_B2B_ORDER, true);
    }

    public ChannelOptB2BOrderRespDto executeSub(DgF2BOrderThroughRespDto throughDtoDefine, Object request) {
        ChannelOptB2BOrderRespDto channelOptB2BOrderRespDto = new ChannelOptB2BOrderRespDto();
        List dgPerformOrderRespDtos = this.omsOrderInfoQueryDomain.queryDtoByPlatformOrderNo(throughDtoDefine.getSaleOrderNo());
        List orderItemLineEos = this.performOrderItemLineDomain.queryInfoByOrderIds(dgPerformOrderRespDtos.stream().map(BaseDto::getId).collect(Collectors.toList()));
        Map<Long, List<DgPerformOrderItemLineDto>> orderItemLineEoMap = orderItemLineEos.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineDto::getOrderLineId));
        if (CollectionUtil.isNotEmpty((Collection)dgPerformOrderRespDtos)) {
            ArrayList succItemList = Lists.newArrayList();
            ArrayList returnItemLineList = Lists.newArrayList();
            boolean flag = true;
            StringBuilder errorMsg = new StringBuilder(80);
            for (DgPerformOrderRespDto dgPerformOrderRespDto : dgPerformOrderRespDtos) {
                if (!this.allowOptOrderStatus.contains(dgPerformOrderRespDto.getOrderStatus())) continue;
                try {
                    this.dgB2BOrderStatemachineExecutor.executeStatemachine(DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode(), dgPerformOrderRespDto.getId(), null, (Object)DgB2BOrderMachineEvents.CHANNEL_INVALID_B2B_ORDER);
                    for (DgPerformOrderLineDto omsOrderLineRespDto : dgPerformOrderRespDto.getOrderLineList()) {
                        List<DgPerformOrderItemLineDto> orderItemLineDtos = orderItemLineEoMap.get(omsOrderLineRespDto.getId());
                        if (CollectionUtil.isNotEmpty(orderItemLineDtos)) {
                            ArrayList subItemLineList = Lists.newArrayList();
                            for (DgPerformOrderItemLineDto item : orderItemLineDtos) {
                                if (item.getDeliveryStatus().equals(ItemLineDeliveryStatusEnum.NO.getType())) {
                                    subItemLineList.add(item);
                                    continue;
                                }
                                log.info("\u8ba2\u5355\uff1a{} \u7684\u5546\u54c1\u884c\uff1a{} \u672a\u51fa\u5e93", (Object)item.getOrderId(), (Object)item.getId());
                            }
                            if (CollectionUtil.isNotEmpty((Collection)subItemLineList)) {
                                DgPerformOrderItemRespDto itemRespDto = new DgPerformOrderItemRespDto();
                                itemRespDto.setId(Long.valueOf(omsOrderLineRespDto.getPlatformOrderItemNo()));
                                itemRespDto.setItemId(omsOrderLineRespDto.getItemId());
                                itemRespDto.setItemName(omsOrderLineRespDto.getItemName());
                                itemRespDto.setSkuCode(omsOrderLineRespDto.getSkuCode());
                                itemRespDto.setSkuName(omsOrderLineRespDto.getSkuName());
                                itemRespDto.setItemNum(subItemLineList.stream().map(DgPerformOrderItemLineDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add));
                                succItemList.add(itemRespDto);
                                continue;
                            }
                            log.info("\u6e20\u9053\u8ba2\u5355\u884c\uff1a{} \u5bf9\u5e94\u7684\u5546\u54c1\u884c\u5df2\u7ecf\u5168\u90e8\u51fa\u5e93", (Object)dgPerformOrderRespDto.getId());
                            continue;
                        }
                        log.info("\u6e20\u9053\u8ba2\u5355\u884c\uff1a{} \u6ca1\u6709\u5bf9\u5e94\u5546\u54c1\u884c", (Object)dgPerformOrderRespDto.getId());
                    }
                }
                catch (Exception e) {
                    flag = false;
                    errorMsg.append(dgPerformOrderRespDto.getSaleOrderNo()).append("\u4f9b\u5e94\u94fe\u8ba2\u5355\u53d6\u6d88\u5931\u8d25\uff1a").append(e.getMessage()).append(";");
                    log.info("\u5b8c\u7ed3\u4f9b\u5e94\u94fe\u8ba2\u5355\u5931\u8d25\uff1a{}, \u5931\u8d25\u539f\u56e0\uff1a{}", (Object)dgPerformOrderRespDto.getSaleOrderNo(), (Object)e);
                    e.printStackTrace();
                }
            }
            channelOptB2BOrderRespDto.setAllCancel(flag);
            channelOptB2BOrderRespDto.setErrorMsg(errorMsg.toString());
            channelOptB2BOrderRespDto.setSuccItemList((List)succItemList);
            channelOptB2BOrderRespDto.setRefundItemList((List)returnItemLineList);
        }
        return channelOptB2BOrderRespDto;
    }
}

