/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.b2c.order.common;

import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yunxi.dg.base.components.optlog.core.around.OperationChainAround;
import com.yunxi.dg.base.components.optlog.core.utils.OptUtil;
import com.yunxi.dg.base.components.optlog.core.vo.OperationTriggerVo;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DgB2CConsumerAround {
    private static Logger logger = LoggerFactory.getLogger(DgB2CConsumerAround.class);

    public static <T, R> MessageResponse aroundMqProcess(Function<T, R> function) {
        String reqId = RequestId.createReqId();
        try {
            function.apply(null);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return MessageResponse.SUCCESS;
    }

    public static <T, R> MessageResponse asyncAroundMqProcess(Function<T, R> function) {
        CompletableFuture.runAsync(() -> {
            String reqId = RequestId.createReqId();
            try {
                function.apply(null);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        });
        return MessageResponse.SUCCESS;
    }

    public static <T> MessageResponse aroundMessageConsumer(T message, Function<T, String> getTriggeredType, Function<T, String> getEventCode, Function<T, String> getEventName, Function<T, String> getLinkType, Function<T, String> getLinkCode, Function<T, MessageResponse> consumerMsg) {
        return (MessageResponse)OptUtil.aroundOpt((OperationTriggerVo)OperationChainAround.buildTrigger().triggeredType(getTriggeredType.apply(message)).operationChainEntry(OperationChainAround.buildEntryForStackTraceElement((StackTraceElement[])Thread.currentThread().getStackTrace())).triggeredEvent(getEventName.apply(message)).triggeredEventCode(getEventCode.apply(message)).triggeredChainLinkCode(getLinkCode.apply(message)).triggeredChainLinkType(getLinkType.apply(message)).stepModel(OperationChainAround.STEP_MODEL_2).build(), () -> DgB2CConsumerAround.aroundMqProcess(o -> (MessageResponse)consumerMsg.apply(message)));
    }
}

