/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.b2c.order.scheduled;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.RequestId;
import com.yunxi.dg.base.center.trade.api.order.IPerformOrderQueryApi;
import com.yunxi.dg.base.center.trade.api.strategy.IDgReceiveStrategyApi;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgCisStrategyOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgStrategyConfItemTypeEnum;
import com.yunxi.dg.base.center.trade.dao.mapper.DgPerformOrderInfoMapper;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyConfItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyRuleDomain;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgStrategyRuleEo;
import com.yunxi.dg.base.center.trade.eo.StrategyConfItemEo;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.constant.DgB2COrderMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.execute.DgB2COrderStatemachineExecutor;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"cis.statemachine.oms.config.enable"}, havingValue="true")
@Component
public class DgAutoConfirmReceivedGoodsScheduled {
    private static final Logger LOGGER = LoggerFactory.getLogger(DgAutoConfirmReceivedGoodsScheduled.class);
    private static final String AUTO_CONFIRM_GOODS_LOCK_KEY = "AUTO_CONFIRM_GOODS_LOCK_KEY";
    @Resource
    private ICacheService cacheService;
    @Resource
    private IPerformOrderQueryApi saleOrderQueryApiImpl;
    @Resource
    private IDgReceiveStrategyApi receiveStrategyQueryApi;
    @Resource
    private DgB2COrderStatemachineExecutor orderStatemachineExecutor;
    @Resource
    private IDgStrategyConfItemDomain strategyConfItemDomain;
    @Resource
    private IDgStrategyRuleDomain dgStrategyRuleDomain;
    @Resource
    private DgPerformOrderInfoMapper dgPerformOrderInfoMapper;

    @Scheduled(cron="${oms.sale.order.auto.confirm.received.goods.cron:0 55 23 * * ?}")
    public void autoConfirmReceivedGoods() {
        CompletableFuture.runAsync(this::autoHandleAutoConfirmReceiveGoods);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoHandleAutoConfirmReceiveGoods() {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u786e\u8ba4\u6536\u8d27]\u5b9a\u65f6\u5668\u5f00\u59cb\u6267\u884c\u81ea\u52a8\u786e\u8ba4\u6536\u8d27\u4efb\u52a1!");
        Long lockFlag = this.cacheService.setnx(AUTO_CONFIRM_GOODS_LOCK_KEY, "1");
        if (lockFlag == 1L) {
            LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u786e\u8ba4\u6536\u8d27]\u5b9a\u65f6\u5668\u542f\u52a8");
            try {
                this.handleAutoConfirmReceiveGoods(null);
            }
            catch (Exception e) {
                LOGGER.error("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u786e\u8ba4\u6536\u8d27]\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
            }
            finally {
                this.cacheService.delCache(AUTO_CONFIRM_GOODS_LOCK_KEY);
            }
            LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u786e\u8ba4\u6536\u8d27]\u5b9a\u65f6\u5668\u4efb\u52a1\u6267\u884c\u5b8c\u6210!");
        } else {
            LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u786e\u8ba4\u6536\u8d27]\u5b9a\u65f6\u5668\u4efb\u52a1\u672a\u6267\u884c!");
        }
    }

    private void handleAutoConfirmReceiveGoods(Long nextBeginId) {
        List strategyRuleEos = ((ExtQueryChainWrapper)this.dgStrategyRuleDomain.filter().eq((Object)"strategy_type", (Object)DgCisStrategyOrderTypeEnum.CONFIRM_RECEIPT_POLICY.getCode())).list();
        if (CollectionUtils.isEmpty((Collection)strategyRuleEos)) {
            LOGGER.info("\u672a\u914d\u7f6e\u7535\u5546\u8ba2\u5355\u81ea\u52a8\u6536\u8d27\u7b56\u7565,\u81ea\u52a8\u786e\u8ba4\u6536\u8d27\u4efb\u52a1\u7ed3\u675f");
            return;
        }
        for (DgStrategyRuleEo strategyRuleEo : strategyRuleEos) {
            List confItemEos = ((ExtQueryChainWrapper)this.strategyConfItemDomain.filter().eq((Object)"rule_id", (Object)strategyRuleEo.getId())).list();
            if (CollectionUtils.isEmpty((Collection)confItemEos)) {
                return;
            }
            Map confItemEoMap = confItemEos.stream().collect(Collectors.toMap(StrategyConfItemEo::getStrategyType, Function.identity()));
            String channelCode = ((StrategyConfItemEo)confItemEoMap.get(DgStrategyConfItemTypeEnum.ADAPTATION_CHANNEL.getCode())).getExtension();
            Integer day = Integer.valueOf(((StrategyConfItemEo)confItemEoMap.get(DgStrategyConfItemTypeEnum.TIME_LIMIT.getCode())).getContent());
            day = day == 0 ? 1 : day;
            Instant now = Instant.now();
            LocalDate dateBeforeDays = now.minus(day.intValue(), ChronoUnit.DAYS).atZone(ZoneId.systemDefault()).toLocalDate();
            Date date = Date.from(dateBeforeDays.atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
            String endTime = DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN_HHMM, (Date)date);
            List saleOrderRespDtoList = this.dgPerformOrderInfoMapper.queryNeedConfirmGoodsOrderList(channelCode, endTime);
            if (!CollectionUtils.isNotEmpty((Collection)saleOrderRespDtoList)) continue;
            for (DgPerformOrderRespDto order : saleOrderRespDtoList) {
                try {
                    this.orderStatemachineExecutor.executeStatemachine(DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode(), order.getId(), null, (Object)DgB2COrderMachineEvents.CONFIRM_RECEIVE_GOODS);
                    Thread.sleep(50L);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

