/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.f2b.afterorder.constant;

import com.yunxi.dg.base.center.trade.statemachine.f2b.afterorder.constant.DgF2BAfterStatus;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public enum DgF2BAfterStatusRelEnum {
    CREATED(DgF2BAfterStatus.CREATED),
    WAIT_CHECK(DgF2BAfterStatus.WAIT_CHECK),
    WAIT_AUDIT(DgF2BAfterStatus.WAIT_AUDIT),
    WAIT_IN_STORAGE(DgF2BAfterStatus.WAIT_IN_STORAGE),
    RETURNED_WAIT_CONFIRM(DgF2BAfterStatus.RETURNED_WAIT_CONFIRM),
    WAIT_QUALITY_TEST(DgF2BAfterStatus.WAIT_QUALITY_TEST),
    QUALITY_TEST_WAIT_CONFIRM(DgF2BAfterStatus.QUALITY_TEST_WAIT_CONFIRM),
    WAIT_REFUND(DgF2BAfterStatus.WAIT_REFUND),
    COMPLETE(DgF2BAfterStatus.COMPLETE),
    CANCEL(DgF2BAfterStatus.CANCEL),
    CLOSE(DgF2BAfterStatus.CLOSE);

    private final DgF2BAfterStatusRelEnum parenStatus;
    private final String code;
    private final String desc;
    private final DgF2BAfterStatus targetStatus;
    private final DgF2BAfterStatus showStatus;
    public static final Map<String, DgF2BAfterStatusRelEnum> CODE_LOOKUP;
    public static final Map<String, String> CODE_DESC_MAP;
    public static final Map<DgF2BAfterStatus, DgF2BAfterStatusRelEnum> ORDER_STATUS_REL_ENUM_MAP;

    private DgF2BAfterStatusRelEnum(DgF2BAfterStatus targetStatus) {
        this(targetStatus, targetStatus);
    }

    private DgF2BAfterStatusRelEnum(DgF2BAfterStatusRelEnum parenStatus, DgF2BAfterStatus targetStatus) {
        this.code = targetStatus.getCode();
        this.desc = targetStatus.getDesc();
        this.targetStatus = targetStatus;
        this.parenStatus = parenStatus;
        this.showStatus = parenStatus.getTargetStatus();
    }

    private DgF2BAfterStatusRelEnum(DgF2BAfterStatus showStatus, DgF2BAfterStatus targetStatus) {
        this.code = targetStatus.getCode();
        this.desc = targetStatus.getDesc();
        this.targetStatus = targetStatus;
        this.parenStatus = null;
        this.showStatus = showStatus;
    }

    public static DgF2BAfterStatusRelEnum forCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    public static DgF2BAfterStatusRelEnum forOrderStatus(DgF2BAfterStatus code) {
        return ORDER_STATUS_REL_ENUM_MAP.get((Object)code);
    }

    public Map<String, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public DgF2BAfterStatusRelEnum getParenStatus() {
        return this.parenStatus;
    }

    public DgF2BAfterStatus getTargetStatus() {
        return this.targetStatus;
    }

    public DgF2BAfterStatus getShowStatus() {
        return this.showStatus;
    }

    static {
        CODE_LOOKUP = Arrays.stream(DgF2BAfterStatusRelEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(DgF2BAfterStatusRelEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));
        ORDER_STATUS_REL_ENUM_MAP = new ConcurrentHashMap<DgF2BAfterStatus, DgF2BAfterStatusRelEnum>();
        Arrays.stream(DgF2BAfterStatusRelEnum.values()).forEach(state -> ORDER_STATUS_REL_ENUM_MAP.put(state.getTargetStatus(), (DgF2BAfterStatusRelEnum)((Object)state)));
    }
}

