/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.b2c.aftersale.config.engine.action;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.statemachine.engine.action.AbstractCisBaseStatemachineAction;
import com.dtyunxi.cube.statemachine.engine.action.CisActionDefine;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.constants.DgConsignTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.PlatformAfterSaleOrderStatusEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.PlatformApplyRefundTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemModifyReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgOrderLabelRecordDto;
import com.yunxi.dg.base.center.trade.enums.AfterSaleOrderItemTypeEnum;
import com.yunxi.dg.base.center.trade.enums.SaleOrderItemStatusEnum;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineEo;
import com.yunxi.dg.base.center.trade.statemachine.b2c.aftersale.constant.DgB2CAfterSaleActionDefineEnum;
import com.yunxi.dg.base.center.trade.statemachine.b2c.aftersale.constant.DgB2CAfterSaleMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.b2c.aftersale.constant.DgB2CAfterSaleMachineStatus;
import com.yunxi.dg.base.center.trade.statemachine.b2c.aftersale.vo.DgB2CAfterSaleThroughRespDto;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JTKInterceptSaleOrderLineAction
extends AbstractCisBaseStatemachineAction<DgB2CAfterSaleActionDefineEnum, DgB2CAfterSaleMachineStatus, DgB2CAfterSaleMachineEvents, DgBizAfterSaleOrderReqDto, DgBizAfterSaleOrderReqDto, DgB2CAfterSaleThroughRespDto> {
    private static final Logger log = LoggerFactory.getLogger(JTKInterceptSaleOrderLineAction.class);
    @Resource
    private IDgPerformOrderLineDomain dgPerformOrderLineDomain;
    @Resource
    private IDgOrderLabelRecordDomain dgOrderLabelRecordDomain;
    @Resource
    private IDgOrderLabelItemDomain dgOrderLabelItemDomain;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;

    public JTKInterceptSaleOrderLineAction() {
        super((CisActionDefine)DgB2CAfterSaleActionDefineEnum.JTK_INTERCEPT_SALE_ORDER_LINE, false);
    }

    public DgBizAfterSaleOrderReqDto executeSub(DgB2CAfterSaleThroughRespDto throughSaleOrderDto, DgBizAfterSaleOrderReqDto request) {
        log.info("[\u5e73\u53f0\u4ec5\u9000\u6b3e\u552e\u540e\u62e6\u622a\u9500\u552e\u8ba2\u5355\u884c\u6253\u62e6\u622a\u9000\u6807\u8bc6]-action...");
        String platformOrderNo = request.getPlatformOrderNo();
        if (StringUtils.isBlank((CharSequence)platformOrderNo)) {
            return request;
        }
        List dgPerformOrderInfoEos = this.dgPerformOrderInfoDomain.queryEoByPlatformOrderNo(platformOrderNo);
        if (CollectionUtils.isEmpty((Collection)dgPerformOrderInfoEos)) {
            return request;
        }
        List orderIds = dgPerformOrderInfoEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        List giftOrderLabels = this.dgOrderLabelRecordDomain.queryByOrderIdsAndLabelCodes(orderIds, DgOrderLabelEnum.ORDER_GIFT.getCode());
        ArrayList cancelOrderLineEos = Lists.newArrayList();
        if (Objects.equals(request.getRefundType(), "small_refund") && dgPerformOrderInfoEos.stream().allMatch(ld -> ld.getPlatformOrderId() == null)) {
            throw new BizException("\u552e\u540e\u5339\u914d\u6b63\u5411\u5355\u53ea\u6709\u624b\u5de5\u5355\uff0c\u4e2d\u65ad\u552e\u540e\u8f6c\u5355\u6d41\u7a0b\uff1a" + JSON.toJSONString(dgPerformOrderInfoEos.stream().map(DgPerformOrderInfoEo::getSaleOrderNo).collect(Collectors.toList())));
        }
        for (DgPerformOrderInfoEo dgPerformOrderInfoEo : dgPerformOrderInfoEos) {
            List dgPerformOrderLineEos;
            List platformOrderItemNos;
            List itemModifyReqDtos;
            if (DgOmsSaleOrderStatus.OBSOLETE.getCode().equals(dgPerformOrderInfoEo.getOrderStatus()) || DgOmsSaleOrderStatus.CANCEL.getCode().equals(dgPerformOrderInfoEo.getOrderStatus())) {
                log.info("\u8ba2\u5355ID:{},\u8ba2\u5355\u53f7:{},\u72b6\u6001\u4e3a\u5df2\u4f5c\u5e9f\u548c\u5df2\u53d6\u6d88,\u4e0d\u9700\u8981\u505a\u62e6\u622a\u5904\u7406", (Object)dgPerformOrderInfoEo.getId(), (Object)dgPerformOrderInfoEo.getSaleOrderNo());
                continue;
            }
            if (CollectionUtils.isNotEmpty((Collection)giftOrderLabels)) {
                boolean flag = false;
                for (DgOrderLabelRecordDto giftOrderLabel : giftOrderLabels) {
                    if (!dgPerformOrderInfoEo.getId().equals(giftOrderLabel.getOrderId()) || !dgPerformOrderInfoEo.getOrderType().equals(DgSaleOrderTypeEnum.REPLENISH_ORDER.getType()) || !DgOmsSaleOrderStatus.WAIT_DELIVERY.getCode().equals(dgPerformOrderInfoEo.getOrderStatus()) && !DgOmsSaleOrderStatus.WAIT_PICK.getCode().equals(dgPerformOrderInfoEo.getOrderStatus()) && !DgOmsSaleOrderStatus.WAIT_CHECK.getCode().equals(dgPerformOrderInfoEo.getOrderStatus()) && !DgOmsSaleOrderStatus.WAIT_CUSTOMER_AUDIT.getCode().equals(dgPerformOrderInfoEo.getOrderStatus()) && !DgOmsSaleOrderStatus.WAIT_BUSINESS_AUDIT.getCode().equals(dgPerformOrderInfoEo.getOrderStatus()) && !DgOmsSaleOrderStatus.LACK.getCode().equals(dgPerformOrderInfoEo.getOrderStatus())) continue;
                    log.info("\u8ba2\u5355ID:{},\u8ba2\u5355\u53f7:{},\u4e3a\u8d60\u54c1\u8ba2\u5355\u5e76\u4e14\u662f\u8865\u53d1\u8ba2\u5355,\u72b6\u6001\u4e3a\u672a\u53d1\u8d27\u524d\u7684\u72b6\u6001,\u4e0d\u9700\u8981\u505a\u62e6\u622a\u5904\u7406", (Object)dgPerformOrderInfoEo.getId(), (Object)dgPerformOrderInfoEo.getSaleOrderNo());
                    flag = true;
                }
                if (flag) continue;
            }
            String orderStatus = dgPerformOrderInfoEo.getOrderStatus();
            String platformAfsOrderType = request.getPlatformApplyRefundType();
            PlatformAfterSaleOrderStatusEnum afterSaleOrderStatusEnum = PlatformAfterSaleOrderStatusEnum.forCode((String)request.getPlatformSyncStatus());
            AssertUtils.notNull((Object)afterSaleOrderStatusEnum, (String)("\u9519\u8bef\u540c\u6b65\u72b6\u6001" + request.getPlatformSyncStatus()));
            log.info("\u5e73\u53f0\u552e\u540e\u5355\u53f7:{},\u5bf9\u5e94\u8ba2\u5355\u72b6\u6001:{},\u552e\u540e\u7c7b\u578b:{},\u552e\u540e\u72b6\u6001:{}", new Object[]{request.getPlatformRefundOrderSn(), orderStatus, platformAfsOrderType, afterSaleOrderStatusEnum.getCode()});
            if (!PlatformApplyRefundTypeEnum.REFUND_ONLY.getCode().equals(platformAfsOrderType)) continue;
            log.info("\u5e73\u53f0\u63a8\u9001\u552e\u540e\u5355\u7c7b\u578b\u4e3a\u4ec5\u9000\u6b3e");
            if (PlatformAfterSaleOrderStatusEnum.WAIT_AGREE.equals((Object)afterSaleOrderStatusEnum) || PlatformAfterSaleOrderStatusEnum.SUCCEED.equals((Object)afterSaleOrderStatusEnum) || PlatformAfterSaleOrderStatusEnum.WAIT_SALES_REFUND.equals((Object)afterSaleOrderStatusEnum)) {
                List cancelOrderLineEoList;
                log.info("\u5e73\u53f0\u63a8\u9001\u552e\u540e\u5355\u72b6\u6001\u4e3a\u4e70\u5bb6\u5df2\u7533\u8bf7\u9000\u6b3e/\u6362\u8d27\uff0c\u7b49\u5f85\u540c\u610f\uff0c\u6362\u8d27/\u9000\u6b3e\u6210\u529f\uff0c\u5356\u5bb6\u5df2\u540c\u610f\u9000\u6b3e\uff0c\u7b49\u5f85\u9000\u6b3e,\u9700\u8981\u6253\u62e6\u622a\u9000\u6807\u8bc6");
                log.info("\u8ba2\u5355\u72b6\u6001\u4e3a\u5f85\u5ba1\u6838/\u5f85\u5ba2\u5ba1/\u5f85\u5546\u5ba1/\u5f85\u914d\u8d27/\u5f85\u53d1\u8d27/\u7f3a\u8d27/\u5df2\u914d\u8d27\u72b6\u6001\uff0c\u9700\u8981\u6253\u62e6\u622a\u9000\u6807\u8bc6,\u8ba2\u5355\u72b6\u6001:{}", (Object)orderStatus);
                if (DgOmsSaleOrderStatus.WAIT_AUDIT.getCode().equals(orderStatus) || DgOmsSaleOrderStatus.WAIT_BUSINESS_AUDIT.getCode().equals(orderStatus) || DgOmsSaleOrderStatus.WAIT_CUSTOMER_AUDIT.getCode().equals(orderStatus) || DgOmsSaleOrderStatus.WAIT_DELIVERY.getCode().equals(orderStatus) || DgOmsSaleOrderStatus.WAIT_PICK.getCode().equals(orderStatus) || DgOmsSaleOrderStatus.WAIT_CHECK.getCode().equals(orderStatus) || DgOmsSaleOrderStatus.LACK.getCode().equals(orderStatus) || DgOmsSaleOrderStatus.PICKED.getCode().equals(orderStatus)) {
                    if (Objects.equals(dgPerformOrderInfoEo.getConsignType(), DgConsignTypeEnum.THIRD.getType()) && Objects.equals(DgOmsSaleOrderStatus.LACK.getCode(), orderStatus)) continue;
                    itemModifyReqDtos = request.getAfterSaleOrderItemReqDtoList().stream().filter(i -> i.getAfterSaleOrderItemType().equals(AfterSaleOrderItemTypeEnum.SH.getType())).collect(Collectors.toList());
                    platformOrderItemNos = itemModifyReqDtos.stream().map(DgAfterSaleOrderItemReqDto::getPlatformOrderItemNo).collect(Collectors.toList());
                    dgPerformOrderLineEos = this.dgPerformOrderLineDomain.queryEosByPlatformOrderItemNosAndOrderId(platformOrderItemNos, dgPerformOrderInfoEo.getId());
                    if (CollectionUtils.isEmpty((Collection)dgPerformOrderLineEos)) {
                        log.info("\u672a\u67e5\u5230\u6b63\u5411\u8ba2\u5355\u884c\u5546\u54c1\u4fe1\u606f");
                        log.info("\u672a\u67e5\u5230\u6b63\u5411\u8ba2\u5355\u884c\u5546\u54c1\u4fe1\u606f,\u6574\u5355\u62e6\u622a,\u9632\u6b62\u8d85\u53d1");
                        List dgPerformOrderLineEoList = this.dgPerformOrderLineDomain.queryEosByPlatformOrderNo(request.getPlatformOrderNo());
                        for (DgPerformOrderLineEo lineEo : dgPerformOrderLineEoList) {
                            this.dgOrderLabelItemDomain.addOrderLabelItem(lineEo.getOrderId(), lineEo.getId(), DgOrderLabelEnum.REFUND_ITEM);
                        }
                        this.dgOrderLabelRecordDomain.addOrderLabelRecord(((DgPerformOrderLineEo)dgPerformOrderLineEoList.get(0)).getOrderId(), DgOrderLabelEnum.REFUND_INTERCEPT);
                        continue;
                    }
                    cancelOrderLineEoList = dgPerformOrderLineEos.stream().filter(e -> e.getStatus().equals(SaleOrderItemStatusEnum.CANCEL.getCode())).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(cancelOrderLineEoList)) {
                        log.info("\u5b58\u5728\u5df2\u53d6\u6d88\u7684\u8ba2\u5355\u884c");
                        cancelOrderLineEos.addAll(cancelOrderLineEoList);
                    }
                    boolean orderLinelanjietuiFlag = false;
                    for (DgPerformOrderLineEo lineEo : dgPerformOrderLineEos) {
                        if (CollectionUtils.isNotEmpty(cancelOrderLineEoList)) {
                            List cancelPlatformOrderItemNo = cancelOrderLineEoList.stream().map(DgPerformOrderLineEo::getPlatformOrderItemNo).collect(Collectors.toList());
                            if (cancelPlatformOrderItemNo.contains(lineEo.getPlatformOrderItemNo())) continue;
                            this.dgOrderLabelItemDomain.addOrderLabelItem(lineEo.getOrderId(), lineEo.getId(), DgOrderLabelEnum.REFUND_ITEM);
                            orderLinelanjietuiFlag = true;
                            continue;
                        }
                        this.dgOrderLabelItemDomain.addOrderLabelItem(lineEo.getOrderId(), lineEo.getId(), DgOrderLabelEnum.REFUND_ITEM);
                        orderLinelanjietuiFlag = true;
                    }
                    if (orderLinelanjietuiFlag) {
                        this.dgOrderLabelRecordDomain.addOrderLabelRecord(((DgPerformOrderLineEo)dgPerformOrderLineEos.get(0)).getOrderId(), DgOrderLabelEnum.REFUND_INTERCEPT);
                    }
                } else if (DgOmsSaleOrderStatus.DELIVERED.getCode().equals(orderStatus) || DgOmsSaleOrderStatus.DELIVERY_ALL.getCode().equals(orderStatus) || DgOmsSaleOrderStatus.COMPLETE.getCode().equals(orderStatus)) {
                    itemModifyReqDtos = request.getAfterSaleOrderItemReqDtoList().stream().filter(i -> i.getAfterSaleOrderItemType().equals(AfterSaleOrderItemTypeEnum.SH.getType())).collect(Collectors.toList());
                    platformOrderItemNos = itemModifyReqDtos.stream().map(DgAfterSaleOrderItemReqDto::getPlatformOrderItemNo).collect(Collectors.toList());
                    dgPerformOrderLineEos = this.dgPerformOrderLineDomain.queryEosByPlatformOrderItemNosAndOrderId(platformOrderItemNos, dgPerformOrderInfoEo.getId());
                    if (CollectionUtils.isEmpty((Collection)dgPerformOrderLineEos)) {
                        log.info("\u672a\u67e5\u5230\u6b63\u5411\u8ba2\u5355\u884c\u5546\u54c1\u4fe1\u606f");
                        continue;
                    }
                    cancelOrderLineEoList = dgPerformOrderLineEos.stream().filter(e -> e.getStatus().equals(SaleOrderItemStatusEnum.CANCEL.getCode())).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(cancelOrderLineEoList)) {
                        log.info("\u5b58\u5728\u5df2\u53d6\u6d88\u7684\u8ba2\u5355\u884c");
                        cancelOrderLineEos.addAll(cancelOrderLineEoList);
                    }
                }
            }
            if (!PlatformAfterSaleOrderStatusEnum.SELLER_REJECT.equals((Object)afterSaleOrderStatusEnum) && !PlatformAfterSaleOrderStatusEnum.CLOSE.equals((Object)afterSaleOrderStatusEnum)) continue;
            log.info("\u5356\u5bb6\u62d2\u7edd\u9000\u6b3e\uff0c\u9000\u6b3e\u5173\u95ed");
            if (!DgOmsSaleOrderStatus.WAIT_AUDIT.getCode().equals(orderStatus) && !DgOmsSaleOrderStatus.WAIT_BUSINESS_AUDIT.getCode().equals(orderStatus) && !DgOmsSaleOrderStatus.WAIT_CUSTOMER_AUDIT.getCode().equals(orderStatus) && !DgOmsSaleOrderStatus.WAIT_DELIVERY.getCode().equals(orderStatus) && !DgOmsSaleOrderStatus.WAIT_PICK.getCode().equals(orderStatus) && !DgOmsSaleOrderStatus.WAIT_CHECK.getCode().equals(orderStatus) && !DgOmsSaleOrderStatus.LACK.getCode().equals(orderStatus) && !DgOmsSaleOrderStatus.PICKED.getCode().equals(orderStatus)) continue;
            log.info("\u8ba2\u5355\u72b6\u6001\u4e3a\u5f85\u5ba1\u6838/\u5f85\u5ba2\u5ba1/\u5f85\u5546\u5ba1/\u5f85\u914d\u8d27/\u5f85\u53d1\u8d27/\u7f3a\u8d27/\u5df2\u914d\u8d27\u72b6\u6001\uff0c\u9700\u8981\u79fb\u9664\u62e6\u622a\u9000\u6807\u8bc6,\u8ba2\u5355\u72b6\u6001:{}", (Object)orderStatus);
            itemModifyReqDtos = request.getAfterSaleOrderItemReqDtoList().stream().filter(i -> i.getAfterSaleOrderItemType().equals(AfterSaleOrderItemTypeEnum.SH.getType())).collect(Collectors.toList());
            platformOrderItemNos = itemModifyReqDtos.stream().map(DgAfterSaleOrderItemReqDto::getPlatformOrderItemNo).collect(Collectors.toList());
            dgPerformOrderLineEos = this.dgPerformOrderLineDomain.queryEosByPlatformOrderItemNosAndOrderId(platformOrderItemNos, dgPerformOrderInfoEo.getId());
            if (CollectionUtils.isEmpty((Collection)dgPerformOrderLineEos)) continue;
            for (DgPerformOrderLineEo lineEo : dgPerformOrderLineEos) {
                this.dgOrderLabelItemDomain.removeOrderLabelItemById(lineEo.getOrderId(), lineEo.getId(), DgOrderLabelEnum.REFUND_ITEM);
            }
            this.dgOrderLabelRecordDomain.removeOrderLabelRecordById(((DgPerformOrderLineEo)dgPerformOrderLineEos.get(0)).getOrderId(), DgOrderLabelEnum.REFUND_INTERCEPT);
        }
        if (CollectionUtils.isNotEmpty((Collection)cancelOrderLineEos)) {
            ArrayList newAfsItemList = Lists.newArrayList();
            List cancelPlatformOrderItemNo = cancelOrderLineEos.stream().map(DgPerformOrderLineEo::getPlatformOrderItemNo).collect(Collectors.toList());
            for (DgAfterSaleOrderItemModifyReqDto itemModifyReqDto : request.getAfterSaleOrderItemReqDtoList()) {
                if (cancelPlatformOrderItemNo.contains(itemModifyReqDto.getPlatformOrderItemNo())) continue;
                newAfsItemList.add(itemModifyReqDto);
            }
            request.setAfterSaleOrderItemReqDtoList((List)newAfsItemList);
        }
        if (CollectionUtils.isEmpty((Collection)request.getAfterSaleOrderItemReqDtoList())) {
            throw new BizException("\u6ca1\u6709\u53ef\u7533\u8bf7\u552e\u540e\u7684\u5546\u54c1\u4fe1\u606f");
        }
        return request;
    }
}

