/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.f2b.order.config.engine.action;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.statemachine.engine.action.AbstractCisBaseStatemachineAction;
import com.dtyunxi.cube.statemachine.engine.action.CisActionDefine;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.constants.DgPlatFormOrderSelectTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformNoticeSyncRecordItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.ChannelOptB2BOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.enums.ItemLineDeliveryStatusEnum;
import com.yunxi.dg.base.center.trade.service.oms.common.ICommonOrderQueryService;
import com.yunxi.dg.base.center.trade.statemachine.b2b.order.constant.DgB2BOrderMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.b2b.order.constant.DgB2BOrderStatus;
import com.yunxi.dg.base.center.trade.statemachine.b2b.order.execute.DgB2BOrderStatemachineExecutor;
import com.yunxi.dg.base.center.trade.statemachine.f2b.order.constant.DgF2BOrderActionDefineEnum;
import com.yunxi.dg.base.center.trade.statemachine.f2b.order.constant.DgF2BOrderMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.f2b.order.constant.DgF2BOrderMachineStatus;
import com.yunxi.dg.base.center.trade.statemachine.f2b.order.vo.DgF2BOrderThroughRespDto;
import com.yunxi.dg.base.commons.dto.BaseDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DgF2BCompletedB2bOrderAction
extends AbstractCisBaseStatemachineAction<DgF2BOrderActionDefineEnum, DgF2BOrderMachineStatus, DgF2BOrderMachineEvents, Object, ChannelOptB2BOrderRespDto, DgF2BOrderThroughRespDto> {
    private static final Logger log = LoggerFactory.getLogger(DgF2BCompletedB2bOrderAction.class);
    @Resource
    private DgB2BOrderStatemachineExecutor dgB2BOrderStatemachineExecutor;
    @Resource
    private IDgPerformNoticeSyncRecordItemDomain dgPerformNoticeSyncRecordItemDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgPerformOrderItemLineDomain performOrderItemLineDomain;
    @Resource
    private ICommonOrderQueryService commonOrderQueryService;
    private List<String> allowOptOrderStatus = Lists.newArrayList((Object[])new String[]{DgB2BOrderStatus.WAIT_CHECK.getCode(), DgB2BOrderStatus.WAIT_PICK.getCode(), DgB2BOrderStatus.WAIT_PICK.getCode(), DgB2BOrderStatus.PICKED.getCode(), DgB2BOrderStatus.WAIT_DELIVERY.getCode(), DgB2BOrderStatus.DELIVERY_PART.getCode()});

    public DgF2BCompletedB2bOrderAction() {
        super((CisActionDefine)DgF2BOrderActionDefineEnum.CHANNEL_COMPLETED_B2B_ORDER, true);
    }

    public ChannelOptB2BOrderRespDto executeSub(DgF2BOrderThroughRespDto throughDtoDefine, Object request) {
        List dgPerformOrderRespDtos = this.commonOrderQueryService.queryByPlatFormOrderNo(throughDtoDefine.getSaleOrderNo(), DgPlatFormOrderSelectTypeEnum.NOW_USE.getCode());
        ArrayList succItemList = Lists.newArrayList();
        ArrayList refundItemList = Lists.newArrayList();
        boolean flag = true;
        StringBuilder errorMsg = new StringBuilder(80);
        for (DgPerformOrderRespDto dgPerformOrderRespDto : dgPerformOrderRespDtos) {
            try {
                if (this.allowOptOrderStatus.contains(dgPerformOrderRespDto.getOrderStatus())) {
                    this.dgB2BOrderStatemachineExecutor.executeStatemachine(DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode(), dgPerformOrderRespDto.getId(), null, (Object)DgB2BOrderMachineEvents.CHANNEL_COMPLETED_B2B_ORDER);
                }
                List dgPerformOrderItemRespDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(dgPerformOrderRespDto.getId());
                List orderItemLineDtoList = this.performOrderItemLineDomain.queryInfoByOrderId(dgPerformOrderRespDto.getId());
                Map<Long, List<DgPerformOrderItemLineDto>> orderItemLineMap = orderItemLineDtoList.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineDto::getOrderLineId));
                for (DgPerformOrderLineDto dgPerformOrderItemRespDto : dgPerformOrderItemRespDtos) {
                    BigDecimal deliveryNum = dgPerformOrderItemRespDto.getOutItemNum();
                    if (dgPerformOrderItemRespDto.getCalcItemNum().compareTo(deliveryNum) <= 0) continue;
                    DgPerformOrderItemRespDto itemRespDto = new DgPerformOrderItemRespDto();
                    itemRespDto.setId(dgPerformOrderItemRespDto.getId());
                    itemRespDto.setPlatformOrderItemNo(dgPerformOrderItemRespDto.getPlatformOrderItemNo());
                    itemRespDto.setItemId(dgPerformOrderItemRespDto.getItemId());
                    itemRespDto.setItemName(dgPerformOrderItemRespDto.getItemName());
                    itemRespDto.setSkuCode(dgPerformOrderItemRespDto.getSkuCode());
                    itemRespDto.setSkuName(dgPerformOrderItemRespDto.getSkuName());
                    itemRespDto.setItemNum(dgPerformOrderItemRespDto.getCalcItemNum().subtract(deliveryNum));
                    succItemList.add(itemRespDto);
                    refundItemList.addAll(orderItemLineMap.get(dgPerformOrderItemRespDto.getId()).stream().filter(e -> e.getDeliveryStatus().equals(ItemLineDeliveryStatusEnum.NO.getType())).collect(Collectors.toList()));
                }
            }
            catch (Exception e2) {
                flag = false;
                errorMsg.append(dgPerformOrderRespDto.getSaleOrderNo()).append("\u4f9b\u5e94\u94fe\u8ba2\u5355\u5b8c\u7ed3\u5931\u8d25\uff1a").append(e2.getMessage()).append(";");
                log.info("\u5b8c\u7ed3\u4f9b\u5e94\u94fe\u8ba2\u5355\u5931\u8d25\uff1a{}, \u5931\u8d25\u539f\u56e0\uff1a{}", (Object)dgPerformOrderRespDto.getSaleOrderNo(), (Object)e2.getMessage());
                e2.printStackTrace();
            }
        }
        Map<Long, DgPerformOrderItemRespDto> collect = succItemList.stream().collect(Collectors.groupingBy(BaseDto::getId, Collectors.collectingAndThen(Collectors.toList(), items -> {
            BigDecimal itemNum = items.parallelStream().map(DgPerformOrderItemDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            DgPerformOrderItemRespDto itemRespDto = (DgPerformOrderItemRespDto)items.get(0);
            itemRespDto.setItemNum(itemNum);
            return itemRespDto;
        })));
        ChannelOptB2BOrderRespDto channelOptB2BOrderRespDto = new ChannelOptB2BOrderRespDto();
        channelOptB2BOrderRespDto.setAllCancel(flag);
        channelOptB2BOrderRespDto.setErrorMsg(errorMsg.toString());
        channelOptB2BOrderRespDto.setSuccItemList((List)Lists.newArrayList(collect.values()));
        channelOptB2BOrderRespDto.setRefundItemList((List)refundItemList);
        log.info("\u5b8c\u7ed3\u4f9b\u5e94\u94fe\u8ba2\u5355\u7ed3\u679c\uff1a{}", JSON.toJSON((Object)channelOptB2BOrderRespDto));
        return channelOptB2BOrderRespDto;
    }
}

