/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.f2b.order.constant;

import com.dtyunxi.yundt.cube.center.trade.api.constant.DgF2BOrderStatus;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public enum DgF2BOrderStatusRelEnum {
    CREATED(DgF2BOrderStatus.CREATED),
    WAIT_CHECK(DgF2BOrderStatus.WAIT_CHECK),
    WAIT_PAY(DgF2BOrderStatus.WAIT_PAY),
    WAIT_CS_AUDIT(DgF2BOrderStatus.WAIT_CS_AUDIT),
    WAIT_PUSH(DgF2BOrderStatus.WAIT_PUSH),
    WAIT_FINANCE_AUDIT(DgF2BOrderStatus.WAIT_FINANCE_AUDIT),
    WAIT_EXTERNAL_AUDIT(DgF2BOrderStatus.WAIT_EXTERNAL_AUDIT),
    WAIT_PICK(DgF2BOrderStatus.WAIT_PICK),
    WAIT_OUT_STORAGE(DgF2BOrderStatus.WAIT_OUT_STORAGE),
    ALL_DELIVERY(DgF2BOrderStatus.ALL_DELIVERY),
    PART_DELIVERY(DgF2BOrderStatus.PART_DELIVERY),
    CANCEL(DgF2BOrderStatus.CANCEL),
    CLOSE(DgF2BOrderStatus.CLOSE),
    CONFIRM(DgF2BOrderStatus.CONFIRM);

    private final DgF2BOrderStatusRelEnum parenStatus;
    private final String code;
    private final String desc;
    private final DgF2BOrderStatus targetStatus;
    private final DgF2BOrderStatus showStatus;
    public static final Map<String, DgF2BOrderStatusRelEnum> CODE_LOOKUP;
    public static final Map<String, String> CODE_DESC_MAP;
    public static final Map<DgF2BOrderStatus, DgF2BOrderStatusRelEnum> ORDER_STATUS_REL_ENUM_MAP;

    private DgF2BOrderStatusRelEnum(DgF2BOrderStatus targetStatus) {
        this(targetStatus, targetStatus);
    }

    private DgF2BOrderStatusRelEnum(DgF2BOrderStatusRelEnum parenStatus, DgF2BOrderStatus targetStatus) {
        this.code = targetStatus.getCode();
        this.desc = targetStatus.getDesc();
        this.targetStatus = targetStatus;
        this.parenStatus = parenStatus;
        this.showStatus = parenStatus.getTargetStatus();
    }

    private DgF2BOrderStatusRelEnum(DgF2BOrderStatus showStatus, DgF2BOrderStatus targetStatus) {
        this.code = targetStatus.getCode();
        this.desc = targetStatus.getDesc();
        this.targetStatus = targetStatus;
        this.parenStatus = null;
        this.showStatus = showStatus;
    }

    public static DgF2BOrderStatusRelEnum forCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    public static DgF2BOrderStatusRelEnum forOrderStatus(DgF2BOrderStatus code) {
        return ORDER_STATUS_REL_ENUM_MAP.get(code);
    }

    public Map<String, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public DgF2BOrderStatusRelEnum getParenStatus() {
        return this.parenStatus;
    }

    public DgF2BOrderStatus getTargetStatus() {
        return this.targetStatus;
    }

    public DgF2BOrderStatus getShowStatus() {
        return this.showStatus;
    }

    static {
        CODE_LOOKUP = Arrays.stream(DgF2BOrderStatusRelEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(DgF2BOrderStatusRelEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));
        ORDER_STATUS_REL_ENUM_MAP = new ConcurrentHashMap<DgF2BOrderStatus, DgF2BOrderStatusRelEnum>();
        Arrays.stream(DgF2BOrderStatusRelEnum.values()).forEach(state -> ORDER_STATUS_REL_ENUM_MAP.put(state.getTargetStatus(), (DgF2BOrderStatusRelEnum)((Object)state)));
    }
}

