/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.handler.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.enums.SortOrder;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlOrderBy;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.util.ParamConverter;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.dto.entity.OperationLogDto;
import com.yunxi.dg.base.center.trade.service.sys.IDgStatemachineEventExecuteRecordService;
import com.yunxi.dg.base.center.trade.statemachine.b2b.order.constant.DgB2BOrderActionDefineEnum;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.constant.DgB2COrderActionDefineEnum;
import com.yunxi.dg.base.center.trade.statemachine.handler.IOperationLogHandle;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.components.optlog.domain.entity.IOptOperationLogDomain;
import com.yunxi.dg.base.components.optlog.eo.OptOperationLogEo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OperationLogHandleImpl
implements IOperationLogHandle {
    private static final Logger log = LoggerFactory.getLogger(OperationLogHandleImpl.class);
    @Resource
    private IDgStatemachineEventExecuteRecordService dgStatemachineEventExecuteRecordService;
    @Resource
    private IOptOperationLogDomain<OptOperationLogEo> optOperationLogDomain;

    @Override
    public RestResponse<PageInfo<OperationLogDto>> queryOptLogPage(Long orderId, Integer pageSize, Integer pageNum) {
        OptOperationLogEo optOperationLogEo = new OptOperationLogEo();
        optOperationLogEo.setOptLinkCode(orderId.toString());
        optOperationLogEo.setOptLinkType("PERFORM_ORDER");
        optOperationLogEo.setOptResult("SUCCESS");
        optOperationLogEo.setSqlOrderBys(Arrays.asList(new SqlOrderBy("create_time", SortOrder.DESC)));
        PageInfo optOperationLogEos = this.optOperationLogDomain.selectPage((BaseEo)optOperationLogEo, pageNum, pageSize);
        if (optOperationLogEos == null) {
            return new RestResponse();
        }
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)optOperationLogEos, (String[])new String[]{"list", "navigatepageNums"});
        LinkedList operationLogEoList = new LinkedList();
        Map omap = optOperationLogEos.getList().stream().collect(Collectors.toMap(eo -> eo.getOptCorrelationId() + eo.getOptEntryCode() + eo.getOptLinkCode() + eo.getOptLinkType(), Function.identity(), (eo1, eo2) -> {
            eo1.setOptTraceId(null);
            eo1.setOptDetailsCode(eo1.getOptDetailsCode() + "," + eo2.getOptDetailsCode());
            eo1.setOptDetails(eo1.getOptDetails() + "," + eo2.getOptDetails());
            eo1.setOptContent(eo1.getOptContent() + "\n" + eo2.getOptContent());
            return eo1;
        }));
        omap.forEach((k, eo) -> operationLogEoList.add(eo));
        ArrayList dtoList = new ArrayList();
        CubeBeanUtils.copyCollection(dtoList, operationLogEoList, OperationLogDto.class);
        dtoList.sort((dto1, dto2) -> dto2.getOptTime().compareTo(dto1.getOptTime()));
        dtoPageInfo.setList(dtoList);
        return new RestResponse((Object)dtoPageInfo);
    }

    @Override
    public RestResponse<PageInfo<OperationLogDto>> queryEventRecordPage(Long orderId, Integer pageSize, Integer pageNum) {
        AssertUtils.notNull((Object)orderId, (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        PageInfo statemachineEventExecuteRecordDtoPageInfo = this.dgStatemachineEventExecuteRecordService.queryByOrderId(orderId, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)statemachineEventExecuteRecordDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        statemachineEventExecuteRecordDtoPageInfo.getList().forEach(dto -> {
            DgPerformOrderBizModelEnum dgPerformOrderBizModelEnum = DgPerformOrderBizModelEnum.forCode((String)dto.getBizModel());
            if (dto.getExtension() != null && dto.getExtension().startsWith("{")) {
                JSONObject extMap = JSON.parseObject((String)dto.getExtension());
                JSONArray allActionResult = extMap.getJSONArray("allActionResult");
                if (allActionResult != null) {
                    allActionResult.stream().forEach(jsObj -> {
                        OperationLogDto operationLogDto = new OperationLogDto();
                        operationLogDto.setId(Long.valueOf(IdGenrator.getDistributedId()));
                        operationLogDto.setOptTraceId(ParamConverter.convertToString((Object)dto.getId()));
                        operationLogDto.setOptLinkCode(ParamConverter.convertToString((Object)dto.getThroughId()));
                        operationLogDto.setOptEntry(dto.getEventDesc());
                        operationLogDto.setOptEntryCode(dto.getEvent());
                        String actionCode = ((JSONObject)jsObj).getString("action");
                        if (!"GUARD".equals(actionCode) && !"EMPTY".equals(actionCode)) {
                            if (dgPerformOrderBizModelEnum == DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER) {
                                DgB2BOrderActionDefineEnum dgB2BOrderAct = DgB2BOrderActionDefineEnum.forCode(actionCode);
                                operationLogDto.setOptDetails(dgB2BOrderAct.getDesc());
                                operationLogDto.setOptDetailsCode(dgB2BOrderAct.getCode());
                            } else if (dgPerformOrderBizModelEnum == DgPerformOrderBizModelEnum.INVOICE_ORDER) {
                                DgB2COrderActionDefineEnum dgB2COrderActionDefineEnum = DgB2COrderActionDefineEnum.forCode(actionCode);
                                operationLogDto.setOptDetails(dgB2COrderActionDefineEnum.getDesc());
                                operationLogDto.setOptDetailsCode(dgB2COrderActionDefineEnum.getCode());
                            } else {
                                operationLogDto.setOptDetails(actionCode);
                                operationLogDto.setOptDetailsCode(actionCode);
                            }
                            operationLogDto.setOptContent(operationLogDto.getOptDetails());
                            operationLogDto.setOptPerson(dto.getCreatePerson());
                            operationLogDto.setOptTime(dto.getPreEventTime());
                            dtoList.add(operationLogDto);
                        }
                    });
                } else {
                    OperationLogDto operationLogDto = new OperationLogDto();
                    operationLogDto.setId(Long.valueOf(IdGenrator.getDistributedId()));
                    operationLogDto.setOptTraceId(ParamConverter.convertToString((Object)dto.getId()));
                    operationLogDto.setOptLinkCode(ParamConverter.convertToString((Object)dto.getThroughId()));
                    operationLogDto.setOptEntry(dto.getEventDesc());
                    operationLogDto.setOptEntryCode(dto.getEvent());
                    operationLogDto.setOptDetails(dto.getEventDesc());
                    operationLogDto.setOptDetailsCode(dto.getEvent());
                    operationLogDto.setOptPerson(dto.getCreatePerson());
                    operationLogDto.setOptContent(operationLogDto.getOptDetails());
                    operationLogDto.setOptTime(dto.getPreEventTime());
                    dtoList.add(operationLogDto);
                }
            } else {
                OperationLogDto operationLogDto = new OperationLogDto();
                operationLogDto.setId(Long.valueOf(IdGenrator.getDistributedId()));
                operationLogDto.setOptTraceId(ParamConverter.convertToString((Object)dto.getId()));
                operationLogDto.setOptLinkCode(ParamConverter.convertToString((Object)dto.getThroughId()));
                operationLogDto.setOptEntry(dto.getEventDesc());
                operationLogDto.setOptEntryCode(dto.getEvent());
                operationLogDto.setOptDetails(dto.getEventDesc());
                operationLogDto.setOptDetailsCode(dto.getEvent());
                operationLogDto.setOptPerson(dto.getCreatePerson());
                operationLogDto.setOptContent(operationLogDto.getOptDetails());
                operationLogDto.setOptTime(dto.getPreEventTime());
                dtoList.add(operationLogDto);
            }
        });
        dtoPageInfo.setList(dtoList);
        return new RestResponse((Object)dtoPageInfo);
    }

    @Override
    public void manuallyInsertLog(OperationLogDto operationLogDto) {
        log.info("\u624b\u52a8\u63d2\u5165\u65e5\u5fd7:{}", (Object)JSON.toJSONString((Object)operationLogDto));
        OptOperationLogEo optOperationLogEo = new OptOperationLogEo();
        CubeBeanUtils.copyProperties((Object)optOperationLogEo, (Object)operationLogDto, (String[])new String[0]);
        this.optOperationLogDomain.insert((BaseEo)optOperationLogEo);
    }
}

