/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.helper;

import com.yunxi.dg.base.commons.annotations.ExtensionDtoExtends;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionDtoClassMapHelper {
    private static final Logger log = LoggerFactory.getLogger(ExtensionDtoClassMapHelper.class);
    private static final Map<Class<?>, Class> EXT_DTO_CLASS_MAP = new ConcurrentHashMap();

    public static <R> Class<R> getExtClass(Class<?> cls) {
        return EXT_DTO_CLASS_MAP.get(cls);
    }

    public static void setExtClass(Class<?> cls, Class<?> extCls) {
        EXT_DTO_CLASS_MAP.put(cls, extCls);
    }

    public static void scanAndInitMap(String ... packageNames) {
        Stream.of(packageNames).forEach(packageName -> {
            try {
                ExtensionDtoClassMapHelper.scanPackage(packageName).forEach(cls -> Optional.ofNullable(cls.getAnnotation(ExtensionDtoExtends.class)).ifPresent(extensionDtoExtends -> {
                    Class superClass = cls.getSuperclass();
                    if (!Objects.equals(Object.class, superClass)) {
                        ExtensionDtoClassMapHelper.setExtClass(superClass, cls);
                    }
                }));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        });
    }

    public static List<Class<?>> scanPackage(String packageName) throws ClassNotFoundException {
        ArrayList classes = new ArrayList();
        String packagePath = packageName.replace('.', '/');
        File packageDir = new File(Objects.requireNonNull(ExtensionDtoClassMapHelper.class.getClassLoader().getResource(packagePath)).getFile());
        ExtensionDtoClassMapHelper.scanClasses(packageName, packageDir, classes);
        return classes;
    }

    private static void scanClasses(String packageName, File directory, List<Class<?>> classes) throws ClassNotFoundException {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    String subPackageName = packageName + "." + file.getName();
                    ExtensionDtoClassMapHelper.scanClasses(subPackageName, file, classes);
                    continue;
                }
                if (!file.getName().endsWith(".class")) continue;
                String className = file.getName().substring(0, file.getName().length() - 6);
                Class<?> clazz = Class.forName(packageName + "." + className);
                classes.add(clazz);
            }
        }
    }
}

