/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.utils;

import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.yunxi.dg.base.commons.utils.Consumer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Service(value="repeatFilter")
public class RepeatFilter {
    private static final Logger logger = LoggerFactory.getLogger(RepeatFilter.class);
    private static final String REPEAT_FLAG_KEY = "REPEAT_FLAG_KEY";
    private static final Integer DEFAULT_LOCK_TIME = 10;
    public static final String REPEAT_EXCEPTION_CODE = "304";
    @Resource
    private ICacheService cacheService;
    @Resource
    private ILockService lockService;

    public void checkRepeat(String uniqueKey, Consumer consumer, boolean exception) {
        this.checkRepeat(uniqueKey, consumer, exception, "\u64cd\u4f5c\u9891\u7e41");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRepeat(String uniqueKey, Consumer consumer, boolean exception, String msg) {
        Mutex repeatFlag;
        if (StringUtils.isNotEmpty((CharSequence)uniqueKey) && (repeatFlag = this.getRepeatFlag(uniqueKey)) != null) {
            logger.info("\u552f\u4e00\u503c[{}]\u975e\u91cd\u590d\u6d88\u8d39,\u5f00\u59cb\u6267\u884c\u4e1a\u52a1\u5904\u7406", (Object)uniqueKey);
            try {
                consumer.accept();
            }
            finally {
                this.lockService.unlock(repeatFlag);
            }
        } else {
            logger.info("\u552f\u4e00\u503c[{}]\u91cd\u590d\u6d88\u8d39,\u4e0d\u5904\u7406", (Object)uniqueKey);
            if (exception) {
                throw new BizException(REPEAT_EXCEPTION_CODE, msg);
            }
        }
    }

    public Mutex getRepeatFlag(@NonNull String key) {
        boolean flag = this.lockService.isLocked(REPEAT_FLAG_KEY, key);
        if (!flag) {
            return this.lock(key);
        }
        return null;
    }

    private Mutex lock(String key) {
        Objects.requireNonNull(key);
        return this.lockService.lock(REPEAT_FLAG_KEY, key, DEFAULT_LOCK_TIME.intValue(), DEFAULT_LOCK_TIME.intValue(), TimeUnit.SECONDS);
    }

    private String combineKey(String ... keys) {
        List<String> keyList = Arrays.asList(keys);
        return StringUtils.join(keyList, (String)":");
    }
}

