/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.utils.decimal;

import com.yunxi.dg.base.commons.utils.decimal.ToBigDecimalFunction;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class CollectorsUtil {
    static final Set<Collector.Characteristics> CH_NOID = Collections.emptySet();

    private CollectorsUtil() {
    }

    private static <I, R> Function<I, R> castingIdentity() {
        return i -> i;
    }

    public static <T> Collector<T, ?, BigDecimal> summingBigDecimal(ToBigDecimalFunction<? super T> mapper) {
        return new CollectorImpl<Object, BigDecimal[], BigDecimal>(() -> new BigDecimal[]{BigDecimal.ZERO}, (a, t) -> {
            a[0] = a[0].add(mapper.applyAsBigDecimal(t));
        }, (a, b) -> {
            a[0] = a[0].add(b[0]);
            return a;
        }, a -> a[0], CH_NOID);
    }

    public static <T> Collector<T, ?, BigDecimal> maxBy(ToBigDecimalFunction<? super T> mapper) {
        return new CollectorImpl<Object, BigDecimal[], BigDecimal>(() -> new BigDecimal[]{new BigDecimal(Long.MIN_VALUE)}, (a, t) -> {
            a[0] = a[0].max(mapper.applyAsBigDecimal(t));
        }, (a, b) -> {
            a[0] = a[0].max(b[0]);
            return a;
        }, a -> a[0], CH_NOID);
    }

    public static <T> Collector<T, ?, BigDecimal> minBy(ToBigDecimalFunction<? super T> mapper) {
        return new CollectorImpl<Object, BigDecimal[], BigDecimal>(() -> new BigDecimal[]{new BigDecimal(Long.MAX_VALUE)}, (a, t) -> {
            a[0] = a[0].min(mapper.applyAsBigDecimal(t));
        }, (a, b) -> {
            a[0] = a[0].min(b[0]);
            return a;
        }, a -> a[0], CH_NOID);
    }

    public static <T> Collector<T, ?, BigDecimal> averagingBigDecimal(ToBigDecimalFunction<? super T> mapper, int newScale, int roundingMode) {
        return new CollectorImpl<Object, BigDecimal[], BigDecimal>(() -> new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO}, (a, t) -> {
            a[0] = a[0].add(mapper.applyAsBigDecimal(t));
            a[1] = a[1].add(BigDecimal.ONE);
        }, (a, b) -> {
            a[0] = a[0].add(b[0]);
            return a;
        }, a -> a[0].divide(a[1], 4).setScale(newScale, roundingMode), CH_NOID);
    }

    static class CollectorImpl<T, A, R>
    implements Collector<T, A, R> {
        private final Supplier<A> supplier;
        private final BiConsumer<A, T> accumulator;
        private final BinaryOperator<A> combiner;
        private final Function<A, R> finisher;
        private final Set<Collector.Characteristics> characteristics;

        CollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Function<A, R> finisher, Set<Collector.Characteristics> characteristics) {
            this.supplier = supplier;
            this.accumulator = accumulator;
            this.combiner = combiner;
            this.finisher = finisher;
            this.characteristics = characteristics;
        }

        CollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Set<Collector.Characteristics> characteristics) {
            this(supplier, accumulator, combiner, CollectorsUtil.castingIdentity(), characteristics);
        }

        @Override
        public BiConsumer<A, T> accumulator() {
            return this.accumulator;
        }

        @Override
        public Supplier<A> supplier() {
            return this.supplier;
        }

        @Override
        public BinaryOperator<A> combiner() {
            return this.combiner;
        }

        @Override
        public Function<A, R> finisher() {
            return this.finisher;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return this.characteristics;
        }
    }
}

