/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.dataFetch;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.utils.ReflectUtil;
import com.dtyunxi.dto.BasePageDto;
import com.dtyunxi.util.SpringBeanUtil;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.commons.dataFetch.FetchProperties;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

@FunctionalInterface
public interface FetchDataService<REQ, RESP> {
    public static final String PAGE_SIZE = "pageSize";
    public static final String PAGE_NUM = "pageNum";

    public PageInfo<RESP> fetch(REQ var1);

    default public List<RESP> fetchAll(REQ req) {
        FetchProperties properties = (FetchProperties)SpringBeanUtil.getBean(FetchProperties.class);
        this.setPageNum(1, req);
        this.setPageSize(properties.getLimitPageSize(), req);
        PageInfo<RESP> fetch = this.fetch(req);
        int total = Math.min((int)fetch.getTotal(), properties.getLimitMaxSize());
        ArrayList resp = new ArrayList(total);
        if (CollectionUtil.isEmpty((Collection)fetch.getList())) {
            return resp;
        }
        resp.addAll(fetch.getList());
        if (total <= 1) {
            return resp;
        }
        Stream.iterate(2, n -> n + 1).limit(total / fetch.getPageSize() + (total % fetch.getPageSize() != 0 ? 1 : 0) - 1).forEach(n -> {
            this.setPageNum((int)n, req);
            resp.addAll(this.fetch(req).getList());
        });
        return resp;
    }

    default public <REQ> void setPageNum(int i, REQ req) {
        if (req instanceof BasePageDto) {
            ((BasePageDto)req).setPageNum(Integer.valueOf(i));
        } else {
            this.reflectSetVal(i, req, PAGE_NUM);
        }
    }

    default public <REQ> void reflectSetVal(int i, REQ req, String pageNum) {
        this.getFirst(req, pageNum).ifPresent(field -> {
            field.setAccessible(true);
            try {
                field.set(req, i);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        });
    }

    default public <REQ> Optional<Field> getFirst(REQ req, String fieldName) {
        return ReflectUtil.getAllFields(req.getClass()).stream().filter(field -> field.getName().equals(fieldName)).findFirst();
    }

    default public <REQ> void setPageSize(int i, REQ req) {
        if (req instanceof BasePageDto) {
            ((BasePageDto)req).setPageSize(Integer.valueOf(i));
        } else {
            this.reflectSetVal(i, req, PAGE_SIZE);
        }
    }
}

