/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.exception;

import cn.hutool.core.util.StrUtil;
import com.dtyunxi.cube.commons.beans.ApiResult;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.commons.exceptions.ExceptionCode;
import com.dtyunxi.cube.commons.exceptions.SystemException;
import com.dtyunxi.cube.commons.exceptions.ValidateException;
import com.dtyunxi.cube.framework.feign.CubeExceptionWrapper;
import com.dtyunxi.cube.framework.rest.ApiSignatureException;
import com.dtyunxi.cube.framework.rest.BaseResource;
import com.dtyunxi.cube.framework.rest.ResourceException;
import com.dtyunxi.exceptions.CubeException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.yunxi.dg.base.commons.exception.ApiExceptionProperties;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@ControllerAdvice(annotations={RestController.class})
public class DgApiExceptionAdvice
extends BaseResource
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(DgApiExceptionAdvice.class);
    @Autowired
    public ApiExceptionProperties apiExceptionProperties;
    public static Map<String, String> exceptionMap = new HashMap<String, String>();

    public void run(ApplicationArguments args) {
        Properties properties = DgApiExceptionAdvice.loadYamlProperties();
        Map<String, Object> yamlMap = DgApiExceptionAdvice.propertiesToMap(properties);
        yamlMap.forEach((key, value) -> exceptionMap.put((String)key, (String)value));
        Optional.ofNullable(this.apiExceptionProperties.getException()).ifPresent(exceptionMap::putAll);
    }

    private static Properties loadYamlProperties() {
        try {
            ClassPathResource resource = new ClassPathResource("exceptionProfile.yaml");
            YamlPropertiesFactoryBean yamlFactory = new YamlPropertiesFactoryBean();
            yamlFactory.setResources(new Resource[]{resource});
            yamlFactory.afterPropertiesSet();
            return yamlFactory.getObject();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u52a0\u8f7d YAML \u6587\u4ef6: exceptionProfile.yaml", e);
        }
    }

    private static Map<String, Object> propertiesToMap(Properties properties) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Pattern regex = Pattern.compile("\\[(\\d+)]");
        for (String key : properties.stringPropertyNames()) {
            Matcher matcher = regex.matcher(key);
            if (!matcher.find()) continue;
            String number = matcher.group(1);
            map.put(number, properties.getProperty(key));
        }
        return map;
    }

    @ExceptionHandler(value={ResourceException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public ApiResult<?> handleResourceException(ResourceException ex) {
        log.error(ex.getMessage(), (Throwable)ex);
        return this.makeResult(ex.getCode(), ex.getMessage(), null);
    }

    @ExceptionHandler(value={ValidateException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ApiResult<?> handleValidateException(ValidateException ex) {
        log.error("\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff1a{}", (Object)ex.getMessage());
        return this.makeResult(ex.getCode(), ex.getMessage(), ex.getErrors());
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ApiResult<?> handleBindExceptionException(BindException ex) {
        return this.extractMsg(ex.getBindingResult());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ApiResult<?> handleMethodArgumentException(MethodArgumentNotValidException ex) {
        return this.extractMsg(ex.getBindingResult());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ApiResult<?> handleValidateException(ConstraintViolationException ex) {
        ValidateException vex = new ValidateException(ex);
        log.debug("\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff1a{}", (Object)vex.getMessage());
        return this.makeResult(vex.getCode(), vex.getMessage(), vex.getErrors());
    }

    @ExceptionHandler(value={HttpMessageConversionException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ApiResult<?> handleHttpMessageConversionException(HttpMessageConversionException ex) {
        String msg;
        log.error(ex.getMessage(), (Throwable)ex);
        Throwable throwable = ex.getCause();
        if (throwable instanceof InvalidFormatException) {
            InvalidFormatException ex2 = (InvalidFormatException)throwable;
            msg = String.format("\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d{%s},required\uff1a{%s}", ex2.getValue(), ex2.getTargetType().getName());
        } else if (throwable instanceof JsonParseException) {
            JsonParseException ex2 = (JsonParseException)throwable;
            msg = String.format("\u53c2\u6570\u6709\u8bef,json\u6570\u636e\u683c\u5f0f\u6709\u8bef %s", ex2.getOriginalMessage());
        } else {
            msg = throwable instanceof JsonMappingException ? "\u53c2\u6570\u6709\u8bef,\u53c2\u6570\u683c\u5f0f\u9519\u8bef,\u8f6c\u6362\u5931\u8d25 " : String.format("\u53c2\u6570\u6709\u8bef  %s", ex.getMessage());
        }
        return this.makeResult(ExceptionCode.INVALID_PARAM.getCode(), msg, null);
    }

    @ExceptionHandler(value={TypeMismatchException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ApiResult<?> handleTypeMismatchException4TypeMismatchException(TypeMismatchException ex) {
        log.error(ex.getMessage(), (Throwable)ex);
        String msg = String.format("\u7c7b\u578b\u4e0d\u5339\u914d{%s},required\uff1a{%s}", ex.getValue(), Objects.requireNonNull(ex.getRequiredType()).getName());
        return this.makeResult(ExceptionCode.INVALID_PARAM, msg);
    }

    @ExceptionHandler(value={ServletRequestBindingException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ApiResult<?> handleTypeMismatchException4ServletRequestBindingException(ServletRequestBindingException ex) {
        log.error(ex.getMessage(), (Throwable)ex);
        String msg = ex.getMessage();
        return this.makeResult(ExceptionCode.INVALID_PARAM, msg);
    }

    @ExceptionHandler(value={ApiSignatureException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ApiResult<?> handleApiSignatureException(ApiSignatureException ex) {
        log.error(ex.getMessage(), (Throwable)ex);
        return this.makeResult(Integer.toString(ex.getReason()), ex.getMessage(), null);
    }

    @ExceptionHandler(value={BizException.class})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ApiResult<?> handleBizException(BizException ex) {
        log.error(ex.getMessage(), (Throwable)ex);
        return this.makeResult(ex.getCode(), ex.getMessage() == null ? exceptionMap.getOrDefault(ex.getCode(), "\u4e1a\u52a1\u5904\u7406\u5f02\u5e38") : ex.getMessage(), null);
    }

    @ExceptionHandler(value={SystemException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public ApiResult<?> handleDeelonException(SystemException ex) {
        log.error(ex.getMessage(), (Throwable)ex);
        return this.makeResult(ex.getCode(), ex.getMessage(), null);
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public ApiResult<?> handleccessDeniedException(AccessDeniedException ex) {
        log.error(ex.getMessage(), (Throwable)ex);
        return StrUtil.isEmpty((CharSequence)ex.getMessage()) ? this.fail() : this.fail(ex.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ApiResult<?> handleAllException(Exception ex) {
        log.error(ex.getMessage(), (Throwable)ex);
        if ("com.taobao.hsf.exception.HSFTimeOutException".equals(ex.getClass().getName())) {
            return this.fail("\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
        }
        if ("com.taobao.hsf.exception.HSFException".equals(ex.getClass().getName())) {
            return this.fail("\u670d\u52a1\u5668\u5f02\u5e38\u3002");
        }
        return StrUtil.isEmpty((CharSequence)ex.getMessage()) ? this.fail() : this.fail(ex.getMessage());
    }

    @ExceptionHandler(value={CubeExceptionWrapper.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public ApiResult<?> handleAllException(CubeExceptionWrapper ex) {
        CubeException e = ex.getCause();
        return this.makeResult(e.getCode(), e.getRawMessage(), null);
    }

    private ApiResult<?> extractMsg(BindingResult bindingResult) {
        ValidateException vex = new ValidateException();
        if (bindingResult.hasFieldErrors()) {
            List errors = bindingResult.getFieldErrors();
            for (FieldError err : errors) {
                vex.addError(err.getField(), err.getDefaultMessage());
            }
        }
        log.debug("\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff1a{}", (Object)vex.getMessage());
        return this.makeResult(vex.getCode(), vex.getMessage(), vex.getErrors());
    }

    public static void main(String[] args) {
        String directoryPath = "E:\\project\\operation-digital-base";
        DgApiExceptionAdvice.listDirectories(directoryPath);
    }

    private static void listDirectories(String directoryPath) {
        Path path = Paths.get(directoryPath, new String[0]);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
            for (Path entry : stream) {
                if (!Files.isDirectory(entry, new LinkOption[0])) continue;
                System.out.println(entry.getFileName().toString());
            }
        }
        catch (IOException e) {
            System.err.println("Error reading directory: " + e.getMessage());
        }
    }
}

