/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.dtyunxi.util.ReflectionUtils;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class LogUtils {
    public static String buildLogContent(Object obj, String ... fields) {
        if (obj == null || fields == null || fields.length <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String field : fields) {
            Object fieldValue = ReflectionUtils.getFieldValue((Object)obj, (String)field);
            if (fieldValue == null) continue;
            sb.append(", " + field + ":" + fieldValue);
        }
        if (sb.length() <= 0) {
            return "";
        }
        return sb.substring(2);
    }

    public static String buildLogContent(Object obj) {
        if (obj == null) {
            return "";
        }
        return JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
    }

    public static String buildLogContent(Collection coll) {
        if (CollectionUtils.isEmpty((Collection)coll)) {
            return "";
        }
        return JSON.toJSONString((Object)coll, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
    }

    public static String dealShowValue(String key, String value) {
        String lowerName = key.toLowerCase();
        if (lowerName.indexOf("password") >= 0) {
            value = "***";
        } else if (lowerName.indexOf("accesskey") >= 0 || lowerName.indexOf("accesssecret") >= 0 || lowerName.indexOf("secret") >= 0 || lowerName.indexOf("alipay") >= 0 || lowerName.indexOf("wechat") >= 0 || lowerName.indexOf("phone") >= 0 || lowerName.indexOf("passport") >= 0 || lowerName.indexOf("mobile") >= 0 || lowerName.indexOf("account") >= 0) {
            value = LogUtils.hidePassport(value);
        }
        return value;
    }

    public static String hidePassport(String passport) {
        if (StringUtils.isEmpty((CharSequence)passport)) {
            return passport;
        }
        if (passport.length() <= 1) {
            return passport + "***";
        }
        if (passport.length() <= 4) {
            return passport.substring(0, 1) + "***";
        }
        if (passport.length() <= 6) {
            return passport.substring(0, 2) + "***" + passport.substring(passport.length() - 1);
        }
        return passport.substring(0, 3) + "***" + passport.substring(passport.length() - 3);
    }

    public static String getExecuteTime(long time) {
        return String.format("\u8017\u65f6 %s\u6beb\u79d2", System.currentTimeMillis() - time);
    }
}

