/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.utils;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import java.math.BigDecimal;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SequenceUtil {
    private static final Logger log = LoggerFactory.getLogger(SequenceUtil.class);
    private static ICacheService cacheService;
    private static long sidCount;

    public SequenceUtil(ICacheService service) {
        cacheService = service;
    }

    public static String generateBySecondPrefix(String counterKey, Integer incrLength) {
        DateTime dateTime = new DateTime();
        String nowStr = dateTime.toString("yyyyMMddHHmmss");
        return counterKey + nowStr + SequenceUtil.getIndexByLength(counterKey, incrLength);
    }

    public static String generateBySecond(String counterKey, Integer incrLength) {
        DateTime dateTime = new DateTime();
        String nowStr = dateTime.toString("yyyyMMddHHmmss");
        return nowStr + SequenceUtil.getIndexByLength(counterKey, incrLength);
    }

    public static String generateByMillisecond(String counterKey, Integer incrLength) {
        DateTime dateTime = new DateTime();
        String nowStr = dateTime.toString("yyyyMMddHHmmssSSS");
        return nowStr + SequenceUtil.getIndexByLength(counterKey, incrLength);
    }

    public static String generateByTimeMillis(String counterKey, int incrLength) {
        StringBuilder key = new StringBuilder();
        key.append(System.currentTimeMillis());
        String sequenceStr = SequenceUtil.getIndexByLength(counterKey, incrLength);
        key.append(sequenceStr);
        return key.toString();
    }

    public static String getIndexByLength(String counterKey, Integer length) {
        length = length == null ? 3 : length;
        new String();
        BigDecimal maxPerMSECSize = new BigDecimal(1);
        maxPerMSECSize = maxPerMSECSize.movePointRight(length);
        String format = "%0" + length + "d";
        Long sid = 0L;
        try {
            sid = cacheService.incr(counterKey) % (long)maxPerMSECSize.intValue();
        }
        catch (Exception var7) {
            log.error("\u7f13\u5b58\u670d\u52a1\u5668\u53d1\u751f\u5f02\u5e38\uff0c \u81ea\u589eID\u83b7\u53d6\u5931\u8d25");
            log.error("", (Throwable)var7);
            if (sidCount >= (long)maxPerMSECSize.intValue()) {
                sidCount = 0L;
            }
            sid = sidCount;
        }
        String result = String.format(format, sid);
        return result;
    }

    static {
        sidCount = 0L;
    }
}

