/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.utils.excel;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.hutool.core.collection.CollectionUtil;
import com.yunxi.dg.base.commons.utils.excel.BizExportStyler;
import com.yunxi.dg.base.commons.utils.oss.OssUploadService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EasyPoiExcelUtil {
    private static OssUploadService ossUploadService;

    @Autowired
    public void init(OssUploadService ossService) {
        ossUploadService = ossService;
    }

    public static String exportExcel(List dataList, Class clazz, String sheetName) {
        Workbook workbook = null;
        ExportParams params = EasyPoiExcelUtil.getExportParams(sheetName);
        String exportExcelUrl = "";
        if (CollectionUtil.isNotEmpty((Collection)dataList)) {
            workbook = EasyPoiExcelUtil.writeExcel(workbook, dataList, clazz, params);
            exportExcelUrl = ossUploadService.uploadExcelToOss(workbook, System.currentTimeMillis() + ".xlsx");
        }
        return exportExcelUrl;
    }

    public static Workbook writeExcel(Workbook workbook, List dataList, Class clazz, ExportParams params) {
        if (CollectionUtils.isNotEmpty((Collection)dataList)) {
            workbook = ExcelExportUtil.exportBigExcel((ExportParams)params, (Class)clazz, (Collection)dataList);
        }
        return workbook;
    }

    public static Workbook writeExcelEmpty(Class clazz, ExportParams params) {
        return ExcelExportUtil.exportBigExcel((ExportParams)params, (Class)clazz, Collections.emptySet());
    }

    public static ExportParams getExportParams(String sheetName) {
        if (StringUtils.isBlank((CharSequence)sheetName)) {
            sheetName = "sheet1";
        }
        ExportParams params = new ExportParams((String)null, sheetName);
        params.setFixedTitle(true);
        params.setStyle(BizExportStyler.class);
        return params;
    }

    public static void setColumnAutoSize(Workbook workbook) {
        if (workbook != null) {
            int numberOfSheet = workbook.getNumberOfSheets();
            for (int sheetIndex = 0; sheetIndex < numberOfSheet; ++sheetIndex) {
                SXSSFSheet sheet = (SXSSFSheet)workbook.getSheetAt(sheetIndex);
                if (sheet == null) continue;
                sheet.trackAllColumnsForAutoSizing();
                SXSSFRow row = sheet.getRow(sheet.getLastRowNum());
                int columnCounter = EasyPoiExcelUtil.getColumnCount(row);
                for (int columnIndex = 0; columnIndex < columnCounter; ++columnIndex) {
                    sheet.autoSizeColumn(columnIndex);
                    int width = Math.max(3840, Math.min(65280, sheet.getColumnWidth(columnIndex) * 12 / 10));
                    sheet.setColumnWidth(columnIndex, width);
                }
            }
        }
    }

    private static int getColumnCount(SXSSFRow row) {
        return row != null ? row.getLastCellNum() : (short)0;
    }

    private static CellStyle getNumberCellStyle(Workbook wb) {
        CellStyle dataStyle = wb.createCellStyle();
        DataFormat dataFormat = wb.getCreationHelper().createDataFormat();
        short number = dataFormat.getFormat("#,##0.00");
        dataStyle.setDataFormat(number);
        return dataStyle;
    }
}

