/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.dataChange;

import com.dtyunxi.huieryun.util.EoUtil;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.dataChange.DataChangeInterceptUtils;
import java.sql.Connection;
import java.util.List;
import javax.persistence.Table;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class DataChangeIntercept
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(DataChangeIntercept.class);
    static List<String> FOCUS_TYPE_LIST = Lists.newArrayList((Object[])new String[]{SqlCommandType.UPDATE.toString(), SqlCommandType.INSERT.toString(), SqlCommandType.DELETE.toString()});

    public Object intercept(Invocation invocation) throws Throwable {
        if (!DataChangeInterceptUtils.LIMIT_FLAG) {
            return invocation.proceed();
        }
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        MetaObject metaObject = MetaObject.forObject((Object)statementHandler, (ObjectFactory)SystemMetaObject.DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)SystemMetaObject.DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)new DefaultReflectorFactory());
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("parameterHandler.mappedStatement");
        String sqlType = mappedStatement.getSqlCommandType().toString();
        if (FOCUS_TYPE_LIST.contains(sqlType)) {
            Class<?> eoClass = this.getaClass(mappedStatement);
            Table tableAnnotation = eoClass.getAnnotation(Table.class);
            String tableName = tableAnnotation.name();
            if (!DataChangeInterceptUtils.isTableRegistered(tableName)) {
                return invocation.proceed();
            }
            DataChangeInterceptUtils.setIntercept(tableName, sqlType);
            return invocation.proceed();
        }
        return invocation.proceed();
    }

    private Class<?> getaClass(MappedStatement mappedStatement) throws ClassNotFoundException {
        return this.getEoClass(mappedStatement);
    }

    private Class<?> getEoClass(MappedStatement mappedStatement) throws ClassNotFoundException {
        Class<?> classType = Class.forName(mappedStatement.getId().substring(0, mappedStatement.getId().lastIndexOf(".")));
        return EoUtil.getEoClass(classType);
    }

    public Object plugin(Object target) {
        return target instanceof StatementHandler ? Plugin.wrap((Object)target, (Interceptor)this) : target;
    }
}

