/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.dataLimit;

import com.dtyunxi.app.ServiceContext;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnExpression(value="${dtyunxi.cube.starter.data.limit.enable}==true")
@Aspect
public class DataLimitIgnoreAspect {
    private static final Logger log = LoggerFactory.getLogger(DataLimitIgnoreAspect.class);

    @Around(value="@annotation(com.yunxi.dg.base.commons.dataLimit.annotations.DataLimitIgnore)")
    public Object checkPermission(ProceedingJoinPoint joinPoint) throws Throwable {
        ServiceContext.getContext().setAttachment("data_limit_authority_selector_ignore", "data_limit_authority_selector_ignore");
        try {
            Object object = joinPoint.proceed(joinPoint.getArgs());
            return object;
        }
        finally {
            ServiceContext.getContext().remove("data_limit_authority_selector_ignore");
        }
    }
}

