/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.dataLimit;

import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.dataLimit.DataLimitSettingUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.servlet.AsyncHandlerInterceptor;

public class DataLimitReqInterceptor
implements AsyncHandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DataLimitReqInterceptor.class);
    private static final List<String> SEARCH_KEYS = Lists.newArrayList((Object[])new String[]{"query", "Query", "get", "page", "Page", "List", "list", "search", "Search", "detail", "Detail"});

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String requestMethod = request.getMethod();
        if (!HttpMethod.OPTIONS.name().equalsIgnoreCase(requestMethod)) {
            this.checkAndEnableDataLimit(request);
        }
        return true;
    }

    private void checkAndEnableDataLimit(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        String servletPath = request.getServletPath();
        String fullPath = contextPath + servletPath;
        log.info("fullPath:{}", (Object)fullPath);
        if (this.containsPathKeyword(fullPath)) {
            DataLimitSettingUtils.enableDataLimit();
            log.info("\u6570\u636e\u9650\u5236\u5df2\u542f\u7528\uff0c\u5bf9\u4e8e\u8def\u5f84: {}", (Object)fullPath);
        }
    }

    private boolean containsPathKeyword(String path) {
        return SEARCH_KEYS.stream().anyMatch(path::contains);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        DataLimitSettingUtils.disableDataLimit();
    }
}

