/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.mq;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.yunxi.dg.base.commons.utils.MD5Util;
import java.util.HashMap;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class DgSendMqHelper {
    private static final Logger log = LoggerFactory.getLogger(DgSendMqHelper.class);
    @Autowired
    private ICommonsMqService mqService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private Environment environment;

    public void sendPublishMq(Object event, String tag) {
        MessageVo messageVo = this.getMessageVo(event);
        this.sendPublishMq(this.environment.resolvePlaceholders("${inventory.process.mq:PUBLISH_TOPIC}"), messageVo, tag);
    }

    public void sendPublishMq(String topic, Object event, String tag) {
        MessageVo messageVo = this.getMessageVo(event);
        this.mqService.publishMessage(this.environment.resolvePlaceholders(topic), tag, (Object)messageVo);
    }

    public void sendPublishDelayMq(Object event, String tag, Long time) {
        MessageVo messageVo = this.getMessageVo(event);
        this.mqService.publishDelayMessage(this.environment.resolvePlaceholders("${inventory.process.mq:PUBLISH_TOPIC}"), tag, (Object)messageVo, time);
    }

    @NotNull
    private MessageVo getMessageVo(Object event) {
        MessageVo messageVo = new MessageVo();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("yes.req.userCode", ServiceContext.getContext().get("yes.req.userCode"));
        hashMap.put("yes.req.requestId", ServiceContext.getContext().get("yes.req.requestId"));
        String dataStr = JSONObject.toJSONString((Object)event);
        if (dataStr.getBytes().length > 12000) {
            log.info("mq\u5927\u62a5\u6587\u5904\u7406:{}", (Object)dataStr);
            String key = MD5Util.getMd5ByString(dataStr);
            this.cacheService.setCache(key, (Object)dataStr, 21600);
            hashMap.put("yes.req.findDataFlag", key);
            hashMap.put("yes.req.cacheGroup", this.cacheService.getDefaultGroup());
            messageVo.setData((Object)key);
        } else {
            messageVo.setData((Object)dataStr);
        }
        messageVo.setExtValue1((Object)JSONObject.toJSONString(hashMap));
        return messageVo;
    }
}

