/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.utils;

import cn.hutool.crypto.digest.MD5;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AesEncryptUtils {
    public static final String KEY_ALGORITHM = "AES";
    public static final String CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";

    public static byte[] generateKey() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyGenerator keyGenerator = KeyGenerator.getInstance(KEY_ALGORITHM);
        keyGenerator.init(128);
        SecretKey key = keyGenerator.generateKey();
        return key.getEncoded();
    }

    public static AlgorithmParameters generateIV(byte[] AESKey) throws Exception {
        byte[] iv = new byte[16];
        for (int i = 0; i < AESKey.length && i <= 15; ++i) {
            iv[i] = AESKey[i];
        }
        AlgorithmParameters params = AlgorithmParameters.getInstance(KEY_ALGORITHM);
        params.init(new IvParameterSpec(iv));
        return params;
    }

    public static Key convertToKey(byte[] keyBytes) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(keyBytes, KEY_ALGORITHM);
        return secretKey;
    }

    public static byte[] encrypt(byte[] data, byte[] keyBytes, AlgorithmParameters iv) throws Exception {
        Key key = AesEncryptUtils.convertToKey(keyBytes);
        Security.addProvider((Provider)new BouncyCastleProvider());
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(1, key, iv);
        return cipher.doFinal(data);
    }

    public static byte[] decrypt(byte[] encryptedData, byte[] keyBytes, AlgorithmParameters iv) throws Exception {
        Key key = AesEncryptUtils.convertToKey(keyBytes);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(2, key, iv);
        return cipher.doFinal(encryptedData);
    }

    public static String getEncryptKey(String encryptKey, String content) {
        String encryptedString = null;
        byte[] AESKey = Base64.getDecoder().decode(encryptKey + "=");
        try {
            AlgorithmParameters iv = AesEncryptUtils.generateIV(AESKey);
            byte[] encryptedData = AesEncryptUtils.encrypt(content.getBytes(), AESKey, iv);
            encryptedString = Base64.getEncoder().encodeToString(encryptedData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encryptedString;
    }

    public static String getDecryptString(String encryptKey, byte[] encryptedData) {
        String decryptString = null;
        byte[] AESKey = Base64.getDecoder().decode(encryptKey + "=");
        try {
            AlgorithmParameters iv = AesEncryptUtils.generateIV(AESKey);
            byte[] data = AesEncryptUtils.decrypt(encryptedData, AESKey, iv);
            decryptString = Base64.getEncoder().encodeToString(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return decryptString;
    }

    public static String getMd5String(String content, String secret) {
        String md5String = Base64.getEncoder().encodeToString(MD5.create().digest(secret + Base64.getEncoder().encodeToString(MD5.create().digest(content)) + secret));
        return md5String;
    }
}

