/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.utils;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.http.HttpRequest;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtil.class);
    private static int connTimeOut = 60000;

    public static String doGet(String url, Map<String, String> headerMap) {
        return HttpClientUtil.doGet(url, headerMap, CharsetUtil.CHARSET_UTF_8.name(), "application/json", connTimeOut);
    }

    public static String doGet(String url, Map<String, String> headerMap, String charset, String contextType, Integer timeout) {
        charset = StringUtils.isBlank((String)charset) ? "UTF-8" : charset;
        contextType = StringUtils.isBlank((String)contextType) ? "application/json" : contextType;
        timeout = timeout == null ? connTimeOut : timeout;
        return ((HttpRequest)((HttpRequest)HttpRequest.get((String)url).timeout(timeout.intValue()).charset(charset)).contentType(contextType).headerMap(headerMap, true)).execute().body();
    }

    public static String doPut(String url, String bodyJson, Map<String, String> headerMap) {
        return HttpClientUtil.doPut(url, bodyJson, headerMap, "UTF-8", "application/json", connTimeOut);
    }

    public static String doPut(String url, String bodyJson, Map<String, String> headerMap, String charset, String contextType, Integer timeout) {
        charset = StringUtils.isBlank((String)charset) ? "UTF-8" : charset;
        contextType = StringUtils.isBlank((String)contextType) ? "application/json" : contextType;
        timeout = timeout == null ? connTimeOut : timeout;
        return ((HttpRequest)((HttpRequest)HttpRequest.put((String)url).timeout(timeout.intValue()).charset(charset)).headerMap(headerMap, true)).body(bodyJson, contextType).execute().body();
    }

    public static String doPost(String url, String bodyJson, Map<String, String> headerMap) {
        return HttpClientUtil.doPost(url, bodyJson, headerMap, "UTF-8", "application/json", connTimeOut);
    }

    public static String doPost(String url, String bodyJson, Map<String, String> headerMap, String charset, String contextType, Integer timeout) {
        charset = StringUtils.isBlank((String)charset) ? "UTF-8" : charset;
        contextType = StringUtils.isBlank((String)contextType) ? "application/json" : contextType;
        timeout = timeout == null ? connTimeOut : timeout;
        return ((HttpRequest)((HttpRequest)HttpRequest.post((String)url).timeout(timeout.intValue()).charset(charset)).headerMap(headerMap, true)).body(bodyJson, contextType).execute().body();
    }

    public static String doDelete(String url, Map<String, String> headerMap) {
        return HttpClientUtil.doDelete(url, headerMap, "UTF-8", "application/json", connTimeOut);
    }

    public static String doDelete(String url, Map<String, String> headerMap, String charset, String contextType, Integer timeout) {
        charset = StringUtils.isBlank((String)charset) ? "UTF-8" : charset;
        contextType = StringUtils.isBlank((String)contextType) ? "application/json" : contextType;
        timeout = timeout == null ? connTimeOut : timeout;
        return ((HttpRequest)((HttpRequest)HttpRequest.delete((String)url).timeout(timeout.intValue()).charset(charset)).headerMap(headerMap, true)).contentType(contextType).execute().body();
    }

    public static byte[] getBodyStream(String url, String bodyJson) {
        return HttpRequest.post((String)url).body(bodyJson, "application/x-www-form-urlencoded").execute().bodyBytes();
    }

    public static byte[] getBodyStreamGet(String url, String bodyJson) {
        return HttpRequest.get((String)url).body(bodyJson, "application/x-www-form-urlencoded").execute().bodyBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGetByApache(String url, Map<String, String> headerMap) {
        String result = null;
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        try {
            HttpEntity entity;
            httpClient = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet(url);
            httpGet.setConfig(HttpClientUtil.createRequestConfig(connTimeOut));
            if (headerMap != null && headerMap.size() > 0) {
                for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                    httpGet.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if ((entity = (response = httpClient.execute((HttpUriRequest)httpGet)).getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)entity, (Charset)CharsetUtil.CHARSET_UTF_8);
            }
            EntityUtils.consume((HttpEntity)entity);
            response.close();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    log.error("error:", (Throwable)e);
                }
            }
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    log.error("error:", (Throwable)e);
                }
            }
        }
        return result;
    }

    private static RequestConfig createRequestConfig(int timeOut) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(timeOut).setConnectTimeout(timeOut).setSocketTimeout(timeOut).build();
        return requestConfig;
    }

    public static class ContentType {
        public static final String JSON = "application/json";
        public static final String X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
        public static final String FORM_DATA = "multipart/form-data";
        public static final String TEXT_XML = "text/xml";
    }

    public static class Method {
        public static final String GET = "GET";
        public static final String PUT = "PUT";
        public static final String POST = "POST";
        public static final String DELETE = "DELETE";
    }
}

