/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.utils.decimal;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

public class BigDecimalUtils {
    public static final BigDecimal ONE_HUNDRED = BigDecimalUtils.parse("100");

    public static BigDecimal add(BigDecimal a, BigDecimal b) {
        a = BigDecimalUtils.check(a);
        b = BigDecimalUtils.check(b);
        return a.add(b);
    }

    public static BigDecimal subtract(BigDecimal a, BigDecimal b) {
        a = BigDecimalUtils.check(a);
        b = BigDecimalUtils.check(b);
        return a.subtract(b);
    }

    public static BigDecimal multiply(BigDecimal a, BigDecimal b) {
        a = BigDecimalUtils.check(a);
        b = BigDecimalUtils.check(b);
        return a.multiply(b);
    }

    public static BigDecimal divide(BigDecimal a, BigDecimal b) {
        return BigDecimalUtils.divide(a, b, 0);
    }

    public static BigDecimal divide(BigDecimal a, BigDecimal b, int scale) {
        return BigDecimalUtils.divide(a, b, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal divide(BigDecimal a, BigDecimal b, int scale, RoundingMode roundingMode) {
        a = BigDecimalUtils.check(a);
        if (BigDecimalUtils.eqZero(b = BigDecimalUtils.check(b)).booleanValue()) {
            return BigDecimal.ZERO;
        }
        return a.divide(b, scale, roundingMode);
    }

    public static Boolean equals(BigDecimal a, BigDecimal b) {
        return (a = BigDecimalUtils.check(a)).compareTo(b = BigDecimalUtils.check(b)) == 0;
    }

    public static Boolean notEquals(BigDecimal a, BigDecimal b) {
        return BigDecimalUtils.equals(a, b) == false;
    }

    public static Boolean gt(BigDecimal a, BigDecimal b) {
        return (a = BigDecimalUtils.check(a)).compareTo(b = BigDecimalUtils.check(b)) > 0;
    }

    public static Boolean leZero(BigDecimal a) {
        return BigDecimalUtils.le(a, BigDecimal.ZERO);
    }

    public static Boolean ltZero(BigDecimal a) {
        return BigDecimalUtils.lt(a, BigDecimal.ZERO);
    }

    public static Boolean eqZero(BigDecimal a) {
        return BigDecimalUtils.equals(a, BigDecimal.ZERO);
    }

    public static Boolean geZero(BigDecimal a) {
        return BigDecimalUtils.ge(a, BigDecimal.ZERO);
    }

    public static Boolean gtZero(BigDecimal a) {
        return BigDecimalUtils.gt(a, BigDecimal.ZERO);
    }

    public static Boolean lt(BigDecimal a, BigDecimal b) {
        return (a = BigDecimalUtils.check(a)).compareTo(b = BigDecimalUtils.check(b)) < 0;
    }

    public static Boolean ge(BigDecimal a, BigDecimal b) {
        return BigDecimalUtils.equals(a, b) != false || BigDecimalUtils.gt(a, b) != false;
    }

    public static Boolean le(BigDecimal a, BigDecimal b) {
        return BigDecimalUtils.equals(a, b) != false || BigDecimalUtils.lt(a, b) != false;
    }

    public static BigDecimal check(BigDecimal a) {
        return null == a ? BigDecimal.ZERO : a;
    }

    public static BigDecimal abs(BigDecimal a) {
        return BigDecimalUtils.check(a).abs();
    }

    public static BigDecimal negate(BigDecimal a) {
        return BigDecimalUtils.multiply(BigDecimalUtils.check(a), BigDecimalUtils.parse("-1"));
    }

    public static BigDecimal parse(String a) {
        if (StrUtil.isBlank((CharSequence)a)) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(a);
    }

    public static <T> BigDecimal sum(List<T> list, IFeature<T> feature) {
        BigDecimal sum = BigDecimal.ZERO;
        if (CollUtil.isEmpty(list)) {
            return sum;
        }
        for (T t : list) {
            sum = BigDecimalUtils.add(sum, feature.fetch(t));
        }
        return sum;
    }

    @Deprecated
    public static String toString(BigDecimal a) {
        return BigDecimalUtils.toStr(a);
    }

    public static String toStr(BigDecimal a) {
        a = BigDecimalUtils.check(a);
        return a.stripTrailingZeros().toPlainString();
    }

    public static interface IFeature<T> {
        public BigDecimal fetch(T var1);
    }
}

