/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.utils.oss;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ReUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.yunxi.dg.base.commons.utils.oss.BizOssUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class OssUploadService {
    private static final Logger log = LoggerFactory.getLogger(OssUploadService.class);
    @Resource
    private OssRegistryVo registryVo;
    @Resource
    private IObjectStorageService objectStorageService;
    @Resource
    private BizOssUtil bizOssUtil;
    public static final String URL_DELIMITER = "/";
    public static final String EXPORT_DIR = "export";

    public String uploadExportFileToOss(ByteArrayOutputStream byteArrayOutputStream, String fileName) {
        return this.uploadFileToOss(EXPORT_DIR, byteArrayOutputStream, fileName);
    }

    public String copyAndUploadExportFileToOss(InputStream inputStream, String fileName) {
        return this.copyAndUploadFileToOss(EXPORT_DIR, inputStream, fileName);
    }

    public String uploadFileToOss(String ossDir, ByteArrayOutputStream byteArrayOutputStream, String fileName) {
        Assert.hasText((String)ossDir, (String)"\u6587\u4ef6\u76ee\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)fileName, (String)"\u6587\u4ef6\u540d\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (byteArrayOutputStream == null || byteArrayOutputStream.size() <= 0) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u8bf7\u6c42\u53c2\u6570\uff01");
        }
        String ossPath = ossDir + URL_DELIMITER + fileName;
        this.objectStorageService.put(this.registryVo.getBucketName(), ossPath, (InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        String url = this.getPublicDomainUrl(ossDir, fileName);
        if (log.isDebugEnabled()) {
            log.debug("\u4e0a\u4f20\u5230oss\u5b8c\u6210\uff0c\u6587\u4ef6URL:{}", (Object)url);
        }
        return url;
    }

    public String uploadFileToOss(String ossDir, byte[] data, String fileName) {
        Assert.hasText((String)ossDir, (String)"\u6587\u4ef6\u76ee\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)fileName, (String)"\u6587\u4ef6\u540d\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (data == null || data.length <= 0) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u8bf7\u6c42\u53c2\u6570\uff01");
        }
        String ossPath = ossDir + URL_DELIMITER + fileName;
        this.objectStorageService.put(this.registryVo.getBucketName(), ossPath, data);
        String url = this.getPublicDomainUrl(ossDir, fileName);
        if (log.isDebugEnabled()) {
            log.debug("\u4e0a\u4f20\u5230oss\u5b8c\u6210\uff0c\u6587\u4ef6URL:{}", (Object)url);
        }
        return url;
    }

    public String copyAndUploadFileToOss(String ossDir, InputStream inputStream, String fileName) {
        Assert.hasText((String)fileName, (String)"\u6587\u4ef6\u540d\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (inputStream == null) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u8bf7\u6c42\u53c2\u6570\uff01");
        }
        String filePath = this.getSaveFilePath(fileName);
        this.objectStorageService.put(this.registryVo.getBucketName(), filePath, inputStream);
        String url = this.registryVo.getEndpoint() + URL_DELIMITER + filePath;
        if (log.isDebugEnabled()) {
            log.debug("\u4e0a\u4f20\u5230oss\u5b8c\u6210\uff0c\u6587\u4ef6URL:{}", (Object)url);
        }
        return url;
    }

    public String copyAndUploadFileToOss(String fileUrl) {
        StringBuffer fileName = new StringBuffer();
        try {
            InputStream inputStream = null;
            try {
                URL url = new URL(fileUrl);
                inputStream = url.openStream();
            }
            catch (MalformedURLException e) {
                inputStream = FileUtil.getInputStream((String)fileUrl);
            }
            catch (IOException e) {
                log.error("Unable to read filename: ", (Throwable)e);
                throw new RuntimeException("Unable to read filename: " + e.getMessage());
            }
            String timeStamp = this.getTimeStamp();
            fileName.append(timeStamp);
            fileName.append(".");
            String oldFileName = this.getFileName(fileUrl);
            fileName.append(oldFileName);
            return this.copyAndUploadExportFileToOss(inputStream, fileName.toString());
        }
        catch (IORuntimeException e) {
            throw new RuntimeException("Unable to read filename: " + e.getMessage());
        }
    }

    public String copyAndUploadFileToOss(String fileUrl, String posfix) {
        try {
            String regex = "mp4|MP4|mp3|MP3|jpg|JPG|jpeg|JPEG|PNG|png";
            List allMatchStr = ReUtil.findAllGroup0((String)regex, (CharSequence)fileUrl);
            if (CollectionUtil.isNotEmpty((Collection)allMatchStr)) {
                posfix = (String)allMatchStr.get(0);
            }
            InputStream inputStream = null;
            try {
                URL url = new URL(fileUrl);
                inputStream = url.openStream();
            }
            catch (MalformedURLException e) {
                inputStream = FileUtil.getInputStream((String)fileUrl);
            }
            catch (IOException e) {
                log.error("Unable to read filename: ", (Throwable)e);
                throw new RuntimeException("Unable to read filename: " + e.getMessage());
            }
            return this.copyAndUploadExportFileToOss(inputStream, UUID.randomUUID() + "." + posfix);
        }
        catch (IORuntimeException e) {
            throw new RuntimeException("Unable to read filename: " + e.getMessage());
        }
    }

    private String getTimeStamp() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String timeStamp = sdf.format(new Date());
        return timeStamp;
    }

    private String getDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String timeStamp = sdf.format(new Date());
        return timeStamp;
    }

    public String getFileName(String fileUrl) {
        String urlBeiFen = null;
        String extName = null;
        String[] split = fileUrl.split("\\?");
        if (null != split && split.length > 0) {
            fileUrl = split[0];
            urlBeiFen = split[split.length - 1];
        }
        String urlReplace = fileUrl.substring(fileUrl.lastIndexOf(URL_DELIMITER) + 1);
        String urlBeiFenReplace = urlBeiFen.substring(urlBeiFen.lastIndexOf(URL_DELIMITER) + 1);
        String[] split1 = urlReplace.split("\\.");
        extName = null != split1 && split1.length > 1 ? urlReplace : urlBeiFenReplace;
        extName = extName.substring(extName.lastIndexOf(".") + 1);
        extName = extName.substring(extName.lastIndexOf("=") + 1);
        return extName;
    }

    public String uploadExcelToOss(Workbook workbook, String fileName) {
        if (workbook == null) {
            throw new IllegalArgumentException("Workbook\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            workbook.write((OutputStream)outputStream);
            String string = this.uploadExportFileToOss(outputStream, fileName);
            return string;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BizException("Excel\u4e0a\u4f20\u5230OSS\u51fa\u9519\u3002");
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getPublicDomain() {
        String domain = this.bizOssUtil.parseExtProperty("publicDomain", this.registryVo.getExtProperty());
        if (StringUtils.isBlank((CharSequence)domain)) {
            throw new BizException("\u7f3a\u5931\u5bfc\u51fa\u914d\u7f6e\uff0c\u65e0\u6cd5\u5bfc\u51fa\u6587\u4ef6\u3002");
        }
        return domain;
    }

    public String getSaveFilePath(String fileName) {
        if (fileName.contains(URL_DELIMITER)) {
            String[] arrays = fileName.split(URL_DELIMITER);
            String dir = this.registryVo.getDir().replace(URL_DELIMITER, "");
            if (Arrays.asList(arrays).contains(dir)) {
                return fileName;
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.registryVo.getDir());
        builder.append(URL_DELIMITER + this.getDate());
        builder.append(URL_DELIMITER);
        builder.append(fileName);
        return builder.toString();
    }

    public String getPublicDomainUrl(String dir, String fileName) {
        StringBuilder fileUrl = new StringBuilder("");
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            try {
                fileName = URLEncoder.encode(fileName, "UTF-8");
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            fileUrl.append(this.getPublicDomain()).append(URL_DELIMITER).append(dir).append(URL_DELIMITER).append(fileName);
        }
        return fileUrl.toString();
    }

    public String copyAndUploadExportFileToOss(String bucketName, String objectName, String fileUrl) {
        try {
            Object url;
            InputStream inputStream = null;
            try {
                url = new URL(fileUrl);
                inputStream = ((URL)url).openStream();
            }
            catch (MalformedURLException e) {
                inputStream = FileUtil.getInputStream((String)fileUrl);
            }
            url = this.objectStorageService.put(bucketName, objectName, inputStream);
            return url;
        }
        catch (IOException e) {
            log.error("Unable to read filename: ", (Throwable)e);
            throw new RuntimeException("Unable to read filename: " + e.getMessage());
        }
    }
}

