/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.framework.core.service.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.dto.BasePageDto;
import com.yunxi.dg.base.commons.utils.BeanCopyUtil;
import com.yunxi.dg.base.framework.core.convert.DefaultConvertImpl;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.BaseService;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class BaseServiceImpl<T extends BaseDto, E extends BaseEo, D extends IBaseDomain<E>>
implements BaseService<T, E, D> {
    private static final Logger log = LoggerFactory.getLogger(BaseServiceImpl.class);
    protected D domain;
    protected Class<T> tClass = (Class)((ParameterizedType)this.obGenericSuperClass(this.getClass()).getGenericSuperclass()).getActualTypeArguments()[0];
    protected Class<E> eClass = (Class)((ParameterizedType)this.obGenericSuperClass(this.getClass()).getGenericSuperclass()).getActualTypeArguments()[1];
    protected Class<D> dClass = (Class)((ParameterizedType)this.obGenericSuperClass(this.getClass()).getGenericSuperclass()).getActualTypeArguments()[2];

    public BaseServiceImpl(D d) {
        this.domain = d;
    }

    public IConverter<T, E> converter() {
        return new DefaultConvertImpl(this.tClass, this.eClass);
    }

    public Class<? extends BaseServiceImpl> obGenericSuperClass(Class<? extends BaseServiceImpl> cls) {
        if (BaseServiceImpl.class.equals(cls.getSuperclass())) {
            return cls;
        }
        return this.obGenericSuperClass(cls.getSuperclass());
    }

    @Override
    public RestResponse<Long> insert(T dto) {
        E eo = this.converter().toEo(dto);
        this.domain.insert(eo);
        return new RestResponse((Object)eo.getId());
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public RestResponse<Integer> insertBatch(List<T> dtos) {
        return new RestResponse((Object)this.domain.insertBatch(this.converter().toEoList(dtos)));
    }

    @Override
    public RestResponse<Integer> update(T dto) {
        return new RestResponse((Object)this.domain.updateSelective(this.converter().toEo(dto)));
    }

    @Override
    public RestResponse<Void> delete(Long id) {
        this.domain.deleteById(id);
        return new RestResponse();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public RestResponse<Integer> logicDeleteByIds(List<Long> ids) {
        return new RestResponse((Object)this.domain.logicDeleteByIds(ids));
    }

    @Override
    public RestResponse<Void> logicDelete(Long id) {
        this.domain.logicDeleteById(id);
        return new RestResponse();
    }

    @Override
    public RestResponse<T> get(Long id) {
        Object eo = this.domain.selectByPrimaryKey(id);
        return new RestResponse(this.converter().toDto(eo));
    }

    @Override
    public RestResponse<PageInfo<T>> page(T queryDto, Integer currentPage, Integer pageSize) {
        return this.pageForEo(this.converter().toEo(queryDto), currentPage, pageSize);
    }

    protected RestResponse<PageInfo<T>> pageForEo(E queryEo, Integer currentPage, Integer pageSize) {
        PageInfo<E> pageInfo = this.domain.selectPage(queryEo, currentPage, pageSize);
        PageInfo returnPageInfo = new PageInfo();
        BeanCopyUtil.copyProperties(pageInfo, (Object)returnPageInfo);
        if (pageInfo.getSize() > 0) {
            returnPageInfo.setList(this.converter().toDtoList(pageInfo.getList()));
        }
        return new RestResponse((Object)returnPageInfo);
    }

    @Override
    public RestResponse<PageInfo<T>> page(BasePageDto queryDto) {
        return this.page((BaseDto)BeanCopyUtil.copyProperties((Object)queryDto, this.tClass), queryDto.getPageNum(), queryDto.getPageSize());
    }
}

