/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.framework.core.aop.aspect;

import com.yunxi.dg.base.commons.annotations.OptLogEntryMethod;
import com.yunxi.dg.base.components.optlog.core.utils.OptUtil;
import com.yunxi.dg.base.framework.core.utils.SpelUtil;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Method;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOptLogAspect {
    private static final Logger log = LoggerFactory.getLogger(AbstractOptLogAspect.class);

    protected Object optLog(ProceedingJoinPoint point) throws Throwable {
        String linkCode;
        String optCode;
        String optName;
        String linkType = null;
        boolean needCanRetry = false;
        try {
            String linkCodeObj;
            Method entryMethod = ((MethodSignature)point.getSignature()).getMethod();
            Method parentEntryMethod = null;
            try {
                parentEntryMethod = point.getTarget().getClass().getInterfaces()[0].getMethod(entryMethod.getName(), entryMethod.getParameterTypes());
            }
            catch (Exception e) {
                log.warn(entryMethod + "\u975e\u63a5\u53e3\u5b9e\u73b0\u65b9\u6cd5\uff0c\u83b7\u53d6\u7236\u7c7b\u65b9\u6cd5\u5931\u8d25");
            }
            OptLogEntryMethod optLogEntryMethod = entryMethod.getAnnotation(OptLogEntryMethod.class);
            ApiOperation apiOperation = entryMethod.getAnnotation(ApiOperation.class);
            apiOperation = apiOperation == null ? (ApiOperation)Optional.ofNullable(parentEntryMethod).map(pm -> pm.getAnnotation(ApiOperation.class)).orElse(null) : apiOperation;
            optName = Optional.ofNullable(optLogEntryMethod).map(OptLogEntryMethod::optName).orElse(null);
            optName = StringUtils.isBlank((CharSequence)optName) ? (String)Optional.ofNullable(apiOperation).map(ApiOperation::value).orElse(null) : optName;
            optName = StringUtils.isBlank((CharSequence)optName) ? point.getSignature().getName() : optName;
            optCode = Optional.ofNullable(optLogEntryMethod).map(OptLogEntryMethod::optCode).orElse(null);
            optCode = StringUtils.isBlank((CharSequence)optCode) ? optName : optCode;
            String spel = Optional.ofNullable(optLogEntryMethod).map(OptLogEntryMethod::linkCodeSpel).orElse(null);
            String string = linkCodeObj = StringUtils.isBlank((CharSequence)spel) ? optName : SpelUtil.parseSpel(spel, entryMethod, point.getArgs(), Object.class);
            linkCode = linkCodeObj == null ? optName : (StringUtils.isBlank((CharSequence)linkCodeObj.toString()) ? optName : linkCodeObj.toString());
            linkType = Optional.ofNullable(optLogEntryMethod).map(OptLogEntryMethod::linkCodeType).orElse(null);
            linkType = StringUtils.isBlank((CharSequence)linkType) ? optName : linkType;
            needCanRetry = Optional.ofNullable(optLogEntryMethod).map(OptLogEntryMethod::canRetry).orElse(false);
        }
        catch (Exception e) {
            log.warn("\u521d\u59cb\u5316\u64cd\u4f5c\u65e5\u5fd7\u4fe1\u606f\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            return point.proceed();
        }
        return this.doProceed(point, needCanRetry, optName, optCode, linkCode, linkType).getResponse();
    }

    private OptResult doProceed(ProceedingJoinPoint point, boolean needCanRetry, String optName, String optCode, String linkCode, String linkType) throws Throwable {
        OptResult optResult = new OptResult();
        try {
            if (needCanRetry) {
                OptUtil.aroundOpt((ProceedingJoinPoint)point, (String)optCode, (String)optName, (String)linkCode, (String)linkType, () -> {
                    try {
                        Object response = point.proceed();
                        optResult.setResponse(response);
                        return response;
                    }
                    catch (Throwable e) {
                        optResult.setThrowable(e);
                        throw new RuntimeException(e);
                    }
                });
            } else {
                OptUtil.aroundOpt((String)optCode, (String)optName, (String)linkCode, (String)linkType, () -> {
                    try {
                        Object response = point.proceed();
                        optResult.setResponse(response);
                        return response;
                    }
                    catch (Throwable e) {
                        optResult.setThrowable(e);
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        catch (Exception e) {
            if (optResult.getThrowable() != null && e.getCause() == optResult.getThrowable()) {
                throw optResult.getThrowable();
            }
            throw e;
        }
        return optResult;
    }

    private static class OptResult {
        Throwable throwable;
        Object response;

        private OptResult() {
        }

        public void setThrowable(Throwable throwable) {
            this.throwable = throwable;
        }

        public void setResponse(Object response) {
            this.response = response;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public Object getResponse() {
            return this.response;
        }
    }
}

