/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.framework.core.utils;

import com.dtyunxi.util.DateUtil;
import com.google.common.collect.ImmutableMap;
import com.yunxi.dg.base.commons.utils.gen.GenUtils;
import com.yunxi.dg.base.framework.core.api.proxy.ApiProxy;
import com.yunxi.dg.base.framework.core.utils.DefaultMockAnswer;
import io.swagger.annotations.ApiModelProperty;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class MockTestUtil {
    private static final Map<Class<?>, Object> BASE_DATA_MAP = new HashMap();
    private static final Map<ApiModelProperty, List<Object>> API_ENUM_MAP_CACHE = new ConcurrentHashMap<ApiModelProperty, List<Object>>();

    public static boolean isPrimitiveOrWrapper(Class<?> type) {
        return BASE_DATA_MAP.containsKey(type);
    }

    public static <T> T defaultValue(Class<T> primitiveOrWrapperType, Field field) {
        ApiModelProperty apiModelProperty = field.getAnnotation(ApiModelProperty.class);
        if ((String.class.equals(primitiveOrWrapperType) || Integer.class.equals(primitiveOrWrapperType)) && apiModelProperty != null) {
            List<Object> enumsList = API_ENUM_MAP_CACHE.get(apiModelProperty);
            if (enumsList == null) {
                Matcher m = Pattern.compile("\\$\\$.*?\\$\\$").matcher(apiModelProperty.value());
                if (m.find()) {
                    API_ENUM_MAP_CACHE.put(apiModelProperty, GenUtils.extractMessageByRegular((String)m.group(0)).stream().map(str -> str.split(":")[0]).collect(Collectors.toList()));
                } else {
                    API_ENUM_MAP_CACHE.put(apiModelProperty, new ArrayList());
                }
                return MockTestUtil.defaultValue(primitiveOrWrapperType, field);
            }
            if (CollectionUtils.isNotEmpty(enumsList)) {
                if (Integer.class.equals(primitiveOrWrapperType)) {
                    return (T)Integer.valueOf((String)enumsList.get(RandomUtils.nextInt((int)0, (int)(enumsList.size() - 1))));
                }
                if (String.class.equals(primitiveOrWrapperType)) {
                    return (T)enumsList.get(RandomUtils.nextInt((int)0, (int)(enumsList.size() - 1)));
                }
            }
        }
        if (String.class.equals(primitiveOrWrapperType)) {
            return (T)RandomStringUtils.randomAlphanumeric((int)5, (int)32);
        }
        if (Integer.class.equals(primitiveOrWrapperType)) {
            if ("dr".equalsIgnoreCase(field.getName())) {
                return (T)new Integer(0);
            }
            return (T)Integer.valueOf(RandomUtils.nextInt((int)0, (int)99));
        }
        if (Long.class.equals(primitiveOrWrapperType)) {
            return (T)Long.valueOf(RandomUtils.nextLong((long)1100000000000L, (long)1900000000000L));
        }
        if (BigDecimal.class.equals(primitiveOrWrapperType)) {
            return (T)new BigDecimal(RandomUtils.nextDouble());
        }
        if (Date.class.equals(primitiveOrWrapperType)) {
            return (T)new Date();
        }
        return (T)BASE_DATA_MAP.get(primitiveOrWrapperType);
    }

    public static <T extends PX, PX> T mockProxy(PX proxy, Class<T> cls) {
        return MockTestUtil.mockProxy(proxy, cls, null);
    }

    public static <T extends PX, PX> T mockProxy(PX proxy, Class<T> cls, Function<InvocationOnMock, Object> function) {
        if (proxy instanceof ApiProxy) {
            return ((ApiProxy)proxy).mockProxy(MockTestUtil.buildMock(cls, new DefaultMockAnswer(function)));
        }
        return null;
    }

    public static <T> T mockProxy(T proxy, Class<T> cls, T targetProxy) {
        if (targetProxy == null) {
            return MockTestUtil.mockProxy(proxy, cls);
        }
        if (proxy instanceof ApiProxy) {
            return ((ApiProxy)proxy).mockProxy(MockTestUtil.buildMock(cls, new DefaultMockAnswer(invocationOnMock -> {
                Method targetMethod = Stream.of(targetProxy.getClass().getMethods()).filter(method -> {
                    String mStr1 = method.toString().replace(targetProxy.getClass().getName(), "").replace("abstract", "").replace(" ", "");
                    String mStr2 = invocationOnMock.getMethod().toString().replace(cls.getName(), "").replace("abstract", "").replace(" ", "");
                    return mStr1.equalsIgnoreCase(mStr2);
                }).findFirst().orElse(null);
                return Optional.ofNullable(targetMethod).map(tm -> {
                    try {
                        tm.setAccessible(true);
                        return tm.invoke(targetProxy, invocationOnMock.getArguments());
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    return null;
                }).orElse(null);
            })));
        }
        return null;
    }

    public static <T, PX> T mockApi(PX proxy, Class<T> cls) {
        return MockTestUtil.mockApi(proxy, cls, null);
    }

    public static <T, PX> T mockApi(PX proxy, Class<T> cls, Function<InvocationOnMock, Object> function) {
        if (proxy instanceof ApiProxy) {
            return ((ApiProxy)proxy).mockApi(MockTestUtil.buildMock(cls, new DefaultMockAnswer(function)));
        }
        return null;
    }

    public static <T> T buildMock(Class<T> cls) {
        return MockTestUtil.buildMock(cls, null);
    }

    public static <T> T buildMock(Class<T> cls, Answer answer) {
        return (T)(answer == null ? Mockito.mock(cls) : Mockito.mock(cls, (Answer)answer));
    }

    public static <T> T buildDefaultMockObj(Class<T> cls) {
        return MockTestUtil.buildDefaultMockObj(cls, false, null);
    }

    public static <T> T buildSimpleDefaultMockObj(Class<T> cls) {
        return MockTestUtil.buildDefaultMockObj(cls, true, null);
    }

    public static <T> T buildDefaultMockObj(Class<T> cls, boolean simple, Answer<?> answer) {
        if (Modifier.isFinal(cls.getModifiers())) {
            System.out.println("wrong class:" + cls);
            return null;
        }
        Object t = answer == null ? Mockito.mock(cls) : Mockito.mock(cls, answer);
        Field[] fields = cls.getDeclaredFields();
        Stream.of(fields).forEach(field -> {
            if (!field.getName().equalsIgnoreCase("SERIALVERSIONUID")) {
                field.setAccessible(true);
                try {
                    if (simple) {
                        Object spObj = MockTestUtil.baseTypeDefaultValue(field.getType(), field);
                        if (spObj != null) {
                            field.set(t, spObj);
                        }
                    } else {
                        field.set(t, MockTestUtil.buildDefaultValue(field, field.getType()));
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        });
        Class<T> superClass = cls;
        while (!Object.class.equals(superClass)) {
            superClass = superClass.getSuperclass();
            fields = superClass.getDeclaredFields();
            Stream.of(fields).forEach(field -> {
                if (!field.getName().equalsIgnoreCase("SERIALVERSIONUID")) {
                    field.setAccessible(true);
                    try {
                        if (simple) {
                            Object spObj = MockTestUtil.baseTypeDefaultValue(field.getType(), field);
                            if (spObj != null) {
                                field.set(t, spObj);
                            }
                        } else {
                            field.set(t, MockTestUtil.buildDefaultValue(field, field.getType()));
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
            });
        }
        return (T)t;
    }

    public static Object buildDefaultValue(Field field, Class<?> cls) {
        Object defaultValue = MockTestUtil.baseTypeDefaultValue(cls, field);
        if (defaultValue == null) {
            if (cls.equals(List.class)) {
                defaultValue = Arrays.asList(MockTestUtil.buildCollectObjByFieldType(field, 0));
            } else if (cls.equals(Map.class)) {
                defaultValue = ImmutableMap.of((Object)MockTestUtil.buildCollectObjByFieldType(field, 0), (Object)MockTestUtil.buildCollectObjByFieldType(field, 1));
            }
        }
        return defaultValue == null ? MockTestUtil.buildSimpleDefaultMockObj(field.getType()) : defaultValue;
    }

    public static Class<?> accessCollectType(Field field, int typeIndex) {
        ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
        return (Class)parameterizedType.getActualTypeArguments()[typeIndex];
    }

    public static Object buildCollectObjByFieldType(Field field, int typeIndex) {
        Class<?> listType = MockTestUtil.accessCollectType(field, typeIndex);
        Object listObj = MockTestUtil.baseTypeDefaultValue(listType, field);
        return listObj == null ? MockTestUtil.buildSimpleDefaultMockObj(listType) : listObj;
    }

    public static <T> T baseTypeDefaultValue(Class<T> cls, Field field) {
        return MockTestUtil.isPrimitiveOrWrapper(cls) ? (T)MockTestUtil.defaultValue(cls, field) : null;
    }

    public static Answer getDefaultAnswer(Class cls) {
        return invocationOnMock -> {
            try {
                Class<?> resultType = invocationOnMock.getMethod().getReturnType();
                if (invocationOnMock.getMethod().getName().startsWith("get") || invocationOnMock.getMethod().getName().startsWith("is")) {
                    if (resultType.equals(String.class)) {
                        return MockTestUtil.chooseString(invocationOnMock);
                    }
                    if (resultType.equals(Integer.class)) {
                        return MockTestUtil.chooseInt(invocationOnMock);
                    }
                    if (resultType.equals(Long.class)) {
                        return MockTestUtil.chooseLong(invocationOnMock);
                    }
                    if (resultType.equals(Double.class)) {
                        return MockTestUtil.chooseDouble(invocationOnMock);
                    }
                    if (resultType.equals(Float.class)) {
                        return MockTestUtil.chooseFloat(invocationOnMock);
                    }
                    if (resultType.equals(BigDecimal.class)) {
                        return MockTestUtil.chooseBigDecimal(invocationOnMock);
                    }
                    if (resultType.equals(Date.class)) {
                        return MockTestUtil.chooseDate(invocationOnMock);
                    }
                    if (resultType.equals(Boolean.class)) {
                        return MockTestUtil.chooseBoolean(invocationOnMock);
                    }
                    if (resultType.equals(List.class)) {
                        ParameterizedType parameterizedType = (ParameterizedType)invocationOnMock.getMethod().getGenericReturnType();
                        Class listType = (Class)parameterizedType.getActualTypeArguments()[0];
                        return Arrays.asList(Mockito.mock((Class)listType, (Answer)MockTestUtil.getDefaultAnswer(listType)));
                    }
                    if (resultType.equals(Map.class)) {
                        return null;
                    }
                    return Mockito.mock(resultType, (Answer)MockTestUtil.getDefaultAnswer(resultType));
                }
                return invocationOnMock.callRealMethod();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        };
    }

    public static String chooseString(InvocationOnMock invocationOnMock) throws Throwable {
        return (String)Optional.ofNullable(invocationOnMock.callRealMethod()).orElse("mockString");
    }

    public static Integer chooseInt(InvocationOnMock invocationOnMock) throws Throwable {
        return (Integer)Optional.ofNullable(invocationOnMock.callRealMethod()).orElse(1);
    }

    public static Long chooseLong(InvocationOnMock invocationOnMock) throws Throwable {
        return (Long)Optional.ofNullable(invocationOnMock.callRealMethod()).orElse(13000000000001L);
    }

    public static Double chooseDouble(InvocationOnMock invocationOnMock) throws Throwable {
        return (Double)Optional.ofNullable(invocationOnMock.callRealMethod()).orElse(1.2);
    }

    public static Float chooseFloat(InvocationOnMock invocationOnMock) throws Throwable {
        return (Float)Optional.ofNullable(invocationOnMock.callRealMethod()).orElse(Float.valueOf(1.1f));
    }

    public static BigDecimal chooseBigDecimal(InvocationOnMock invocationOnMock) throws Throwable {
        return (BigDecimal)Optional.ofNullable(invocationOnMock.callRealMethod()).orElse(BigDecimal.ONE);
    }

    public static Date chooseDate(InvocationOnMock invocationOnMock) throws Throwable {
        return (Date)Optional.ofNullable(invocationOnMock.callRealMethod()).orElse(DateUtil.parse((String)"2023-01-01"));
    }

    public static Boolean chooseBoolean(InvocationOnMock invocationOnMock) throws Throwable {
        return (Boolean)Optional.ofNullable(invocationOnMock.callRealMethod()).orElse(true);
    }

    static {
        BASE_DATA_MAP.put(Boolean.class, false);
        BASE_DATA_MAP.put(Character.class, Character.valueOf('\u0000'));
        BASE_DATA_MAP.put(Byte.class, (byte)0);
        BASE_DATA_MAP.put(Short.class, (short)0);
        BASE_DATA_MAP.put(Integer.class, 0);
        BASE_DATA_MAP.put(Long.class, 13000000001L);
        BASE_DATA_MAP.put(Float.class, Float.valueOf(0.0f));
        BASE_DATA_MAP.put(Double.class, 0.0);
        BASE_DATA_MAP.put(Date.class, DateUtil.parse((String)"2023-01-01"));
        BASE_DATA_MAP.put(BigDecimal.class, BigDecimal.ONE);
        BASE_DATA_MAP.put(String.class, "dgMockString");
        BASE_DATA_MAP.put(Boolean.TYPE, false);
        BASE_DATA_MAP.put(Character.TYPE, Character.valueOf('\u0000'));
        BASE_DATA_MAP.put(Byte.TYPE, (byte)0);
        BASE_DATA_MAP.put(Short.TYPE, (short)0);
        BASE_DATA_MAP.put(Integer.TYPE, 0);
        BASE_DATA_MAP.put(Long.TYPE, 13000000001L);
        BASE_DATA_MAP.put(Float.TYPE, Float.valueOf(0.0f));
        BASE_DATA_MAP.put(Double.TYPE, 0.0);
    }
}

