/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.plugins.apifox;

import com.dtyunxi.exceptions.BizException;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.utils.apifox.SwaggerApi2ApiFoxJsonUtil;
import com.yunxi.dg.base.plugins.apifox.PluginParameter;
import com.yunxi.dg.base.plugins.apifox.service.ApifoxService;
import com.yunxi.dg.base.plugins.apifox.service.impl.ApifoxServiceImpl;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="ApifoxCodeGenerate")
public class ApifoxCodeGenerateMojo
extends AbstractMojo {
    private final String baseFolder = "/src/main/java/";
    @Parameter(property="projectBaseDir", defaultValue="")
    private String projectBaseDir;
    @Parameter(property="appCode", defaultValue="")
    private String appCode;
    @Parameter(property="basePackage", defaultValue="com.yunxi.dg.base.center")
    private String basePackage;
    @Parameter(property="applicationPackage", defaultValue="")
    private String applicationPackage;
    @Parameter(property="baseSourceFolder", defaultValue="")
    private String baseSourceFolder;
    @Parameter(property="applicationSourceFolder", defaultValue="")
    private String applicationSourceFolder;
    @Parameter(property="isGenerateDto", defaultValue="true")
    private Boolean isGenerateDto;
    @Parameter(property="isGenerateApi", defaultValue="true")
    private Boolean isGenerateApi;
    @Parameter(property="isGenerateController", defaultValue="true")
    private Boolean isGenerateController;
    @Parameter(property="isGenerateProxy", defaultValue="false")
    private Boolean isGenerateProxy;
    @Parameter(property="isGenerateService", defaultValue="true")
    private Boolean isGenerateService;
    @Parameter(property="genIncludeApiClasses", defaultValue="")
    private String genIncludeApiClasses;
    @Parameter(property="jsonPath", defaultValue="")
    private String jsonPath;
    @Parameter(property="gitUrl", defaultValue="")
    private String gitUrl;
    @Parameter(property="gitBranch", defaultValue="")
    private String gitBranch;
    @Parameter(property="targetJson", defaultValue="")
    private String targetJson;
    @Parameter(property="gitUserName", defaultValue="")
    private String gitUserName;
    @Parameter(property="gitPassword", defaultValue="")
    private String gitPassword;
    @Parameter(property="autoCommit", defaultValue="false")
    private Boolean autoCommit;
    @Parameter(property="deployApiJson", defaultValue="false")
    private Boolean deployApiJson;
    @Parameter(property="deployScanPackage", defaultValue="com.yunxi.dg.base.center")
    private String deployScanPackage;
    private ApifoxService apifoxService = new ApifoxServiceImpl();

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            String output = System.getProperty("user.dir");
            if (!output.equals(this.projectBaseDir)) {
                return;
            }
            if (StringUtils.isBlank((CharSequence)this.basePackage)) {
                throw new BizException("ApifoxCodeGenerateMojo\uff1abasePackage \u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)this.jsonPath)) {
                throw new BizException("ApifoxCodeGenerateMojo\uff1ajsonPath \u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)this.appCode)) {
                String lastPart;
                String[] parts = this.basePackage.split("\\.");
                this.appCode = lastPart = parts[parts.length - 1];
            }
            if (StringUtils.isBlank((CharSequence)this.baseSourceFolder)) {
                this.baseSourceFolder = "/src/main/java/" + this.basePackage.replace('.', '/');
            }
            if (StringUtils.isBlank((CharSequence)this.applicationSourceFolder) && StringUtils.isNotBlank((CharSequence)this.applicationPackage)) {
                this.applicationSourceFolder = "/src/main/java/" + this.applicationPackage.replace('.', '/');
            }
            PluginParameter parameter = new PluginParameter();
            parameter.setOutput(output);
            parameter.setAppCode(this.appCode);
            parameter.setBasePackage(this.basePackage);
            parameter.setApplicationPackage(this.applicationPackage);
            parameter.setBaseSourceFolder(this.baseSourceFolder);
            parameter.setApplicationSourceFolder(this.applicationSourceFolder);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            parameter.setDate(simpleDateFormat.format(new Date()));
            parameter.setIsGenerateDto(this.isGenerateDto);
            parameter.setIsGenerateApi(this.isGenerateApi);
            parameter.setIsGenerateController(this.isGenerateController);
            parameter.setIsGenerateProxy(this.isGenerateProxy);
            parameter.setIsGenerateService(this.isGenerateService);
            parameter.setGenIncludeApiClasses(Optional.ofNullable(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.genIncludeApiClasses}) ? this.genIncludeApiClasses : null).map(icl -> icl.split(",")).map(Lists::newArrayList).orElse(new ArrayList()));
            parameter.setJsonPath(this.jsonPath);
            parameter.setGitUrl(this.gitUrl);
            parameter.setGitBranch(this.gitBranch);
            parameter.setTargetJson(this.targetJson);
            parameter.setGitUserName(this.gitUserName);
            parameter.setGitPassword(this.gitPassword);
            parameter.setAutoCommit(this.autoCommit);
            parameter.setDeployApiJson(this.deployApiJson);
            parameter.setDeployScanPackage(this.deployScanPackage);
            this.getLog().info((CharSequence)parameter.toString());
            if (parameter.getDeployApiJson().booleanValue()) {
                String filePath = this.generateApiJson(parameter);
                this.getLog().info((CharSequence)("generateApiJson result:" + filePath));
            } else {
                boolean resultFlag = this.apifoxService.generateCode(parameter);
                this.getLog().info((CharSequence)("result:" + resultFlag));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private String generateApiJson(PluginParameter parameter) {
        String filePath = SwaggerApi2ApiFoxJsonUtil.genApiFoxJson((String)parameter.getDeployScanPackage(), (String)".");
        return filePath;
    }
}

