/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.plugins.framework;

import com.yunxi.dg.base.plugins.framework.PluginParameter;
import com.yunxi.dg.base.plugins.framework.service.FrameworkService;
import com.yunxi.dg.base.plugins.framework.service.impl.FrameworkServiceImpl;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="FrameworkCodeGenerate")
public class FrameworkCodeGenerateMojo
extends AbstractMojo {
    @Parameter(property="appName", defaultValue="xxx\u4e2d\u5fc3")
    private String appName;
    @Parameter(property="projectBaseDir", defaultValue="")
    private String projectBaseDir;
    @Parameter(property="driverClassName", defaultValue="")
    private String driverClassName;
    @Parameter(property="jdbcUrl", defaultValue="")
    private String jdbcUrl;
    @Parameter(property="jdbcUserName", defaultValue="")
    private String jdbcUserName;
    @Parameter(property="jdbcUserPassword", defaultValue="")
    private String jdbcUserPassword;
    @Parameter(property="dbName", defaultValue="")
    private String dbName;
    @Parameter(property="tableNamePrefix", defaultValue="")
    private String tableNamePrefix;
    @Parameter(property="ignoreTables", defaultValue="")
    private String ignoreTables;
    @Parameter(property="includeTables", defaultValue="")
    private String includeTables;
    @Parameter(property="forceCover", defaultValue="false")
    private Boolean forceCover;
    @Parameter(property="basePackage", defaultValue="com.yunxi.dg.base.center")
    private String basePackage;
    @Parameter(property="baseSourceFolder", defaultValue="/src/main/java/com/yunxi/dg/base/center")
    private String baseSourceFolder;
    @Parameter(property="jsonGenApiFlag", defaultValue="false")
    private Boolean jsonGenApiFlag;
    @Parameter(property="genApiCode", defaultValue="false")
    private Boolean genApiCode;
    @Parameter(property="genRestCode", defaultValue="false")
    private Boolean genRestCode;
    @Parameter(property="genServerCode", defaultValue="false")
    private Boolean genServerCode;
    @Parameter(property="genDaoCode", defaultValue="false")
    private Boolean genDaoCode;
    @Parameter(property="genDomainCode", defaultValue="false")
    private Boolean genDomainCode;
    @Parameter(property="genJsonFile", defaultValue="false")
    private Boolean genJsonFile;
    @Parameter(property="isInitCode", defaultValue="false")
    private Boolean isInitCode;
    private FrameworkService frameworkService = new FrameworkServiceImpl();

    public void execute() throws MojoExecutionException, MojoFailureException {
        String output = System.getProperty("user.dir");
        if (!output.equals(this.projectBaseDir)) {
            return;
        }
        PluginParameter parameter = new PluginParameter();
        parameter.setAppName(this.appName);
        parameter.setDriverClassName(this.driverClassName);
        parameter.setJdbcUrl(this.jdbcUrl);
        parameter.setJdbcUserName(this.jdbcUserName);
        parameter.setJdbcUserPassword(this.jdbcUserPassword);
        parameter.setDbName(this.dbName);
        parameter.setIgnoreTables(this.ignoreTables);
        parameter.setIncludeTables(this.includeTables);
        parameter.setTableNamePrefix(this.tableNamePrefix);
        parameter.setForceCover(this.forceCover);
        parameter.setOutput(output);
        parameter.setBasePackage(this.basePackage);
        parameter.setBaseSourceFolder(this.baseSourceFolder);
        parameter.setGenJsonFile(this.genJsonFile);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        parameter.setDate(simpleDateFormat.format(new Date()));
        if (this.isInitCode.booleanValue()) {
            parameter.setGenApiCode(true);
            parameter.setGenRestCode(true);
            parameter.setJsonGenApiFlag(true);
            parameter.setGenServerCode(true);
            parameter.setGenDomainCode(true);
            parameter.setGenDaoCode(true);
        } else {
            parameter.setJsonGenApiFlag(this.jsonGenApiFlag);
            parameter.setGenApiCode(this.genApiCode);
            parameter.setGenRestCode(this.genRestCode);
            parameter.setGenServerCode(this.genServerCode);
            parameter.setGenDomainCode(this.genDomainCode);
            parameter.setGenDaoCode(this.genDaoCode);
        }
        this.getLog().info((CharSequence)parameter.toString());
        boolean resultFlag = this.frameworkService.generateCode(parameter);
        this.getLog().info((CharSequence)("result:" + resultFlag));
    }
}

