package ${vo.basePackage}.convert.entity;

import ${vo.basePackage}.dto.entity.${vo.baseBeanName}Dto;
import ${vo.basePackage}.eo.${vo.baseBeanName}Eo;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;
<#if vo.extTable>import org.mapstruct.MappingTarget;
import com.alibaba.fastjson.JSON;
import com.yunxi.dg.base.commons.helper.ExtensionDtoClassMapHelper;
import org.mapstruct.AfterMapping;
import java.util.Optional;
</#if>

/**
 * @Description ${vo.baseBeanDesc}转换器
 * @Author 代码生成器
 * @Date ${vo.date}
 * @TemplateVersion ${vo.version}
 ${vo.md5Code}
 **/
@Mapper
public interface ${vo.baseBeanName}Converter extends IConverter<${vo.baseBeanName}Dto, ${vo.baseBeanName}Eo> {
     ${vo.baseBeanName}Converter INSTANCE = Mappers.getMapper(${vo.baseBeanName}Converter.class);

<#if vo.extTable>
     @AfterMapping
     default void afterEo2Dto(${vo.baseBeanName}Eo sourceEo, @MappingTarget ${vo.baseBeanName}Dto targetDto) {
         Optional.ofNullable(sourceEo.getExtension()).ifPresent(ext -> {
             targetDto.setExtensionDto(JSON.parseObject(ext, ExtensionDtoClassMapHelper.getExtClass(targetDto.extractExtensionClass())));
         });
     }

     @AfterMapping
     default void afterDto2Eo(${vo.baseBeanName}Dto sourceDto, @MappingTarget ${vo.baseBeanName}Eo targetEo) {
         if (sourceDto.getExtensionDto() == null) {
             targetEo.setExtension(null);
         } else {
             targetEo.setExtension(JSON.toJSONString(sourceDto.getExtensionDto()));
         }
     }
</#if>
}