/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.poi.config;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FileOperationThreadPool {
    @Value(value="${base.mgmt.fileExecutor.corePoolSize:20}")
    private Integer corePoolSize;
    @Value(value="${base.mgmt.fileExecutor.maxPoolSize:20}")
    private Integer maxPoolSize;
    @Value(value="${base.mgmt.fileExecutor.keepAlive:60}")
    private Integer keepAlive;

    @Bean
    public ExecutorService fileOperationExecutor() {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, this.keepAlive.intValue(), TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NameThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
        return threadPoolExecutor;
    }

    class NameThreadFactory
    implements ThreadFactory {
        private AtomicInteger num = new AtomicInteger(0);

        NameThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("\u64cd\u4f5c\u6587\u4ef6\u7684\u7ebf\u7a0b\u6c60\uff1a" + this.num.getAndIncrement());
            return thread;
        }
    }
}

