/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.poi.service;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.afterturn.easypoi.excel.entity.vo.BaseEntityTypeConstants;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.yunxi.dg.base.commons.utils.MD5Util;
import com.yunxi.dg.base.poi.constant.PoiFileModeMap;
import com.yunxi.dg.base.poi.dto.AnalysisSolDefinitionDto;
import com.yunxi.dg.base.poi.dto.CallBackExportParamAsyncRespDto;
import com.yunxi.dg.base.poi.dto.ExcelImportMultiResult;
import com.yunxi.dg.base.poi.dto.ExportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ExportFileParams;
import com.yunxi.dg.base.poi.dto.ExportQueryParamsReqDto;
import com.yunxi.dg.base.poi.dto.ExportSolFileParams;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.enums.BasicDataTypeEnum;
import com.yunxi.dg.base.poi.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.poi.utils.EasyPoiExportUtil;
import com.yunxi.dg.base.poi.utils.SystemConfig;
import com.yunxi.dg.base.poi.utils.excel.NewExcelUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseFileOperationCommonService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBaseFileOperationCommonService.class);
    public static final String RETRY_MAX_COUNT_KEY = "base.mgmt.export.retry.max.count";

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        return null;
    }

    public void callBackImportFileOperationCommonSync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
    }

    public String uploadImportErrorFile(List<? extends ImportBaseModeDto> errorList, String fileName) {
        if (CollectionUtil.isEmpty(errorList)) {
            return "";
        }
        TypeReference<List<Map<String, Object>>> typeReference = new TypeReference<List<Map<String, Object>>>(){};
        List maps = (List)com.alibaba.fastjson.JSON.parseObject((String)JSONUtil.toJsonStr(errorList), (TypeReference)typeReference, (Feature[])new Feature[0]);
        List<ExcelExportEntity> entitys = this.extractImportErrorTitle(((Object)((Object)errorList.get(0))).getClass());
        Workbook workbook = EasyPoiExportUtil.append(maps, entitys, null, fileName);
        return EasyPoiExportUtil.getLoadWorkbookUrl(workbook, fileName);
    }

    private List<ExcelExportEntity> extractImportErrorTitle(Class<? extends ImportBaseModeDto> templateClass) {
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        for (Field field : ReflectUtil.getFields(templateClass)) {
            if (field.getName().equals("errorMsg")) {
                ExcelExportEntity entity = new ExcelExportEntity("\u9519\u8bef\u4fe1\u606f", (Object)field.getName());
                entitys.add(entity);
                continue;
            }
            Excel annotation = field.getAnnotation(Excel.class);
            if (!Objects.nonNull(annotation)) continue;
            ExcelExportEntity entity = new ExcelExportEntity(annotation.name(), (Object)field.getName());
            entity.setFixedIndex(annotation.fixedIndex());
            entitys.add(entity);
        }
        return entitys;
    }

    public List<? extends ExportBaseModeDto> callBackScrollData(ExportQueryParamsReqDto exportQueryParamsReqDto) throws Exception {
        return Collections.emptyList();
    }

    public void callBackExportFinishAsync(CallBackExportParamAsyncRespDto backExportParamAsyncRespDto) {
    }

    public ExcelImportMultiResult<ImportBaseModeDto> parseExcelDataMultiResult(ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ExcelImportMultiResult<ImportBaseModeDto> result = new ExcelImportMultiResult<ImportBaseModeDto>();
        try {
            EasyPoiExportUtil.checkFileInfo(commonReqDto.getImportFileUrl());
            List list = (List)PoiFileModeMap.importTemplateMap.get((Object)commonReqDto.getKey());
            Object obj = list.get(0);
            ArrayList<Class<? extends ImportBaseModeDto>> importTemplateList = new ArrayList<Class>();
            boolean multiFlag = obj instanceof List;
            if (multiFlag) {
                importTemplateList = (List)obj;
            } else {
                importTemplateList.add((Class)obj);
            }
            Integer headRows = (Integer)list.get(1);
            NewExcelUtil excelUtil = new NewExcelUtil(importTemplateList, commonReqDto.getImportFileUrl(), headRows == null ? 1 : headRows);
            logger.info("\u6267\u884c\u89e3\u6790\u4e86");
            excelUtil.execute();
            result.setVerfiyFail(excelUtil.isVerfiyFail());
            result.setFailMap(excelUtil.getFailMap());
            result.setSuccessMap(excelUtil.getSuccessMap());
            result.setTotalRows(excelUtil.getTotalRows());
            if (excelUtil.isVerfiyFail()) {
                logger.info("\u5b58\u5728\u6821\u9a8c\u5931\u8d25\u7684\u6570\u636e");
                result.getFailMap().entrySet().forEach(e -> ((List)e.getValue()).forEach(l -> {
                    l.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", l.getRowNum() + headRows, l.getErrorMsg()));
                    if (!multiFlag) {
                        respDto.getErrorDetails().add((ImportBaseModeDto)((Object)((Object)l)));
                    } else {
                        List errList = respDto.getErrorDetailsMap().getOrDefault(e.getKey(), new ArrayList());
                        errList.add(l);
                        respDto.getErrorDetailsMap().put((Integer)e.getKey(), errList);
                    }
                }));
                respDto.setStatus(CollectionUtil.isNotEmpty(result.getSuccessMap()) ? FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode() : FileOperationStatusEnum.IMPORT_ERROR.getCode());
            }
            if (!(obj instanceof List)) {
                if (CollectionUtil.isNotEmpty(result.getSuccessMap())) {
                    result.setList(result.getSuccessMap().values().iterator().next());
                }
                if (CollectionUtil.isNotEmpty(result.getFailMap())) {
                    result.setFailList(result.getFailMap().values().iterator().next());
                }
            }
        }
        catch (Exception e2) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25:IO\u5f02\u5e38", (Throwable)e2);
            throw new BizException("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25:" + e2.getMessage());
        }
        return result;
    }

    public ExcelImportResult<ImportBaseModeDto> parseExcelDataResult(ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ExcelImportResult result = new ExcelImportResult();
        try {
            EasyPoiExportUtil.checkFileInfo(commonReqDto.getImportFileUrl());
            List list = (List)PoiFileModeMap.importTemplateMap.get((Object)commonReqDto.getKey());
            Object obj = list.get(0);
            ArrayList<Class<? extends ImportBaseModeDto>> importTemplateList = new ArrayList<Class>();
            if (obj instanceof List) {
                importTemplateList = (List)obj;
            } else {
                importTemplateList.add((Class)obj);
            }
            Integer headRows = (Integer)list.get(1);
            NewExcelUtil excelUtil = new NewExcelUtil(importTemplateList, commonReqDto.getImportFileUrl(), headRows == null ? 1 : headRows);
            logger.info("\u6267\u884c\u89e3\u6790\u4e86");
            excelUtil.execute();
            respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
            result.setVerfiyFail(excelUtil.isVerfiyFail());
            result.setFailList(excelUtil.getFailMap().get(0));
            result.setList(excelUtil.getSuccessMap().get(0));
            if (excelUtil.isVerfiyFail()) {
                int index = commonReqDto.getHeadRows() > 0 ? 1 : 0;
                result.getFailList().forEach(l -> respDto.getErrorDetails().add((ImportBaseModeDto)((Object)((Object)String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", l.getRowNum() + index, l.getErrorMsg())))));
                respDto.setStatus(CollectionUtil.isNotEmpty((Collection)result.getList()) ? FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode() : FileOperationStatusEnum.IMPORT_ERROR.getCode());
            }
            return result;
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25:IO\u5f02\u5e38", (Throwable)e);
            throw new BizException("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25:" + e.getMessage());
        }
    }

    public String uploadExportDataFile(ExportQueryParamsReqDto exportQueryParamsReqDto, String fileName, Class<? extends ExportBaseModeDto> exportTemplate) {
        Integer RETRY_MAX_COUNT = Integer.valueOf(SystemConfig.getProperty(RETRY_MAX_COUNT_KEY, "3"));
        List<Object> dataSync = new ArrayList();
        Workbook workbook = null;
        JSONObject jsonObject = JSONUtil.parseObj((String)exportQueryParamsReqDto.getFilter());
        jsonObject.set("pageSize", (Object)exportQueryParamsReqDto.getPageSize());
        if (!exportQueryParamsReqDto.getExtFields().isEmpty()) {
            jsonObject.set("extFields", (Object)exportQueryParamsReqDto.getExtFields());
        }
        String md5 = "";
        do {
            dataSync.clear();
            int count = 0;
            while (count < RETRY_MAX_COUNT) {
                try {
                    jsonObject.set("pageNum", (Object)exportQueryParamsReqDto.getPageNum());
                    exportQueryParamsReqDto.setFilter(JSONUtil.toJsonStr((JSON)jsonObject));
                    dataSync = this.callBackScrollData(exportQueryParamsReqDto);
                    count = RETRY_MAX_COUNT + 1;
                }
                catch (Exception e) {
                    logger.error("\u83b7\u53d6\u6570\u636e\u5931\u8d25\u4e86\uff0c\u5f00\u59cb\u8fdb\u884c\u91cd\u8bd5\uff0c\u76ee\u524d\u91cd\u8bd5\u7684\u6b21\u6570={}", (Object)(++count), (Object)e);
                    if (count < RETRY_MAX_COUNT) continue;
                    throw new BizException("\u62c9\u53d6\u6570\u636e\u5931\u8d25\u4e86");
                }
            }
            String md5Code = MD5Util.getMD5Code((String)com.alibaba.fastjson.JSONObject.toJSONString(dataSync));
            if (CollectionUtil.isEmpty(dataSync) || md5Code.equals(md5)) break;
            md5 = md5Code;
            exportQueryParamsReqDto.setPageNum(exportQueryParamsReqDto.getPageNum() + 1);
            exportQueryParamsReqDto.setExportFileName(StrUtil.isBlank((CharSequence)exportQueryParamsReqDto.getExportFileName()) ? fileName : exportQueryParamsReqDto.getExportFileName());
            if (CollectionUtil.isNotEmpty(dataSync) && !(dataSync.get(0) instanceof Map) && exportQueryParamsReqDto.getExportFileParams() instanceof ExportSolFileParams) {
                TypeReference<List<Map<String, Object>>> typeReference = new TypeReference<List<Map<String, Object>>>(){};
                dataSync = (List)com.alibaba.fastjson.JSON.parseObject((String)com.alibaba.fastjson.JSON.toJSONString(dataSync), (TypeReference)typeReference, (Feature[])new Feature[0]);
            }
            Workbook work = this.getCommonWorkbook(exportQueryParamsReqDto, exportTemplate, dataSync);
            if (workbook != null || work == null) continue;
            workbook = work;
        } while (CollectionUtil.isNotEmpty(dataSync) && jsonObject.getInt((Object)"pageSize") <= dataSync.size());
        if (Objects.isNull(workbook)) {
            logger.info("\u4e0a\u4f20\u6587\u4ef6workbook\u4e3a\u7a7a\u7684");
            return null;
        }
        return EasyPoiExportUtil.getLoadWorkbookUrl(workbook, exportQueryParamsReqDto.getExportFileName());
    }

    private Workbook getCommonWorkbook(ExportQueryParamsReqDto exportQueryParamsReqDto, Class tClass, List dataSync) {
        if (CollectionUtil.isEmpty((Collection)dataSync)) {
            return null;
        }
        Workbook customWorkbook = this.getCustomWorkbook(exportQueryParamsReqDto, dataSync);
        if (Objects.nonNull(customWorkbook)) {
            return customWorkbook;
        }
        return EasyPoiExportUtil.append(dataSync, tClass, null, exportQueryParamsReqDto.getExportFileName());
    }

    private Workbook getCustomWorkbook(ExportQueryParamsReqDto exportQueryParamsReqDto, List dataSync) {
        ExportFileParams params = exportQueryParamsReqDto.getExportFileParams();
        if (!(params instanceof ExportSolFileParams)) {
            return null;
        }
        ExportSolFileParams exportFileParams = (ExportSolFileParams)params;
        ArrayList<ExcelExportEntity> entity = new ArrayList<ExcelExportEntity>();
        for (AnalysisSolDefinitionDto definition : exportFileParams.getDefinitions()) {
            ExcelExportEntity exportEntity = new ExcelExportEntity(definition.getName(), (Object)definition.getKey());
            exportEntity.setFixedIndex(definition.getIndex());
            Integer type = definition.getType().equals(BasicDataTypeEnum.BIGDECIMAL.getType()) || definition.getType().equals(BasicDataTypeEnum.INTEGER.getType()) ? BaseEntityTypeConstants.DOUBLE_TYPE : BaseEntityTypeConstants.STRING_TYPE;
            exportEntity.setType(type.intValue());
            entity.add(exportEntity);
        }
        return EasyPoiExportUtil.append(dataSync, entity, null, exportQueryParamsReqDto.getExportFileName());
    }

    public void initTemplateMap(ExportQueryParamsReqDto exportQueryParamsReqDto) {
    }
}

