/*
 * Decompiled with CFR 0.152.
 */
package io.github.eternalstone.captcha.gp.base;

import io.github.eternalstone.captcha.gp.base.Captcha;
import io.github.eternalstone.captcha.gp.base.TextEntry;
import io.github.eternalstone.captcha.gp.exception.EasyCaptchaException;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public abstract class ArithmeticCaptchaAbstract
extends Captcha {
    private ScriptEngineManager manager = new ScriptEngineManager();
    private ScriptEngine engine = this.manager.getEngineByName("javascript");

    public ArithmeticCaptchaAbstract() {
        this.setLen(2);
    }

    @Override
    public void setLen(int len) {
        if (len < 2) {
            len = 2;
        }
        if (len > 5) {
            len = 5;
        }
        super.setLen(len);
    }

    @Override
    protected char[] alphas() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.len; ++i) {
            sb.append(ArithmeticCaptchaAbstract.num(10));
            if (i >= this.len - 1) continue;
            int type = ArithmeticCaptchaAbstract.num(1, 4);
            if (type == 1) {
                sb.append("+");
                continue;
            }
            if (type == 2) {
                sb.append("-");
                continue;
            }
            if (type != 3) continue;
            sb.append("x");
        }
        return sb.toString().toCharArray();
    }

    @Override
    public TextEntry createText() {
        try {
            char[] alphas = this.alphas();
            StringBuilder arithmetic = new StringBuilder().append(alphas);
            String key = String.valueOf(this.engine.eval(arithmetic.toString().replaceAll("x", "*")));
            char[] arithmeticChars = arithmetic.append("=?").toString().toCharArray();
            return new TextEntry(arithmeticChars, key);
        }
        catch (ScriptException e) {
            throw new EasyCaptchaException("EasyCaptcha Error", e);
        }
    }
}

