/*
 * Decompiled with CFR 0.152.
 */
package io.github.eternalstone.captcha.gp.factory;

import io.github.eternalstone.captcha.gp.base.Captcha;
import io.github.eternalstone.captcha.gp.base.CaptchaEnum;
import io.github.eternalstone.captcha.gp.exception.EasyCaptchaException;
import io.github.eternalstone.captcha.gp.factory.CaptchaProperty;
import java.util.concurrent.ConcurrentHashMap;

public class CaptchaFactory {
    private static final ConcurrentHashMap<CaptchaEnum, Captcha> CAPTCHA_MAP = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Captcha getCaptcha(CaptchaEnum captchaEnum) {
        Captcha captcha = CAPTCHA_MAP.get((Object)captchaEnum);
        if (captcha != null) {
            return captcha;
        }
        try {
            CaptchaEnum captchaEnum2 = captchaEnum;
            synchronized (captchaEnum2) {
                captcha = CAPTCHA_MAP.get((Object)captchaEnum);
                if (captcha != null) {
                    return captcha;
                }
                Class<? extends Captcha> clazz = captchaEnum.getClazz();
                captcha = clazz.newInstance();
                CAPTCHA_MAP.put(captchaEnum, captcha);
                return captcha;
            }
        }
        catch (Exception e) {
            throw new EasyCaptchaException("Initialize Captcha instance exception");
        }
    }

    public static Captcha getCaptcha(CaptchaProperty property) {
        if (property == null) {
            property = new CaptchaProperty();
        }
        Captcha captcha = CaptchaFactory.getCaptcha(property.getCaptcha());
        if (property.getFont() != null) {
            captcha.setFont(property.getFont());
        }
        if (property.getWidth() != null) {
            captcha.setWidth(property.getWidth());
        }
        if (property.getHeight() != null) {
            captcha.setHeight(property.getHeight());
        }
        if (property.getLength() != null) {
            captcha.setLen(property.getLength());
        }
        if (property.getBackground() != null) {
            captcha.setBackground(property.getBackground());
        }
        if (property.getFormat() != null) {
            captcha.setFormat(property.getFormat());
        }
        if (property.getCharType() != null) {
            captcha.setCharType(property.getCharType());
        }
        return captcha;
    }
}

