/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.boot.autoconfigure;

import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.spring.annotation.GlobalTransactionScanner;
import io.seata.spring.annotation.ScannerChecker;
import io.seata.spring.boot.autoconfigure.SeataCoreAutoConfiguration;
import io.seata.spring.boot.autoconfigure.properties.SeataProperties;
import io.seata.tm.api.DefaultFailureHandlerImpl;
import io.seata.tm.api.FailureHandler;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;

@ConditionalOnProperty(prefix="seata", name={"enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureAfter(value={SeataCoreAutoConfiguration.class})
public class SeataAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SeataAutoConfiguration.class);

    @Bean(value={"failureHandler"})
    @ConditionalOnMissingBean(value={FailureHandler.class})
    public FailureHandler failureHandler() {
        return new DefaultFailureHandlerImpl();
    }

    @Bean
    @DependsOn(value={"springApplicationContextProvider", "failureHandler"})
    @ConditionalOnMissingBean(value={GlobalTransactionScanner.class})
    public static GlobalTransactionScanner globalTransactionScanner(SeataProperties seataProperties, FailureHandler failureHandler, ConfigurableListableBeanFactory beanFactory, @Autowired(required=false) List<ScannerChecker> scannerCheckers) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Automatically configure Seata");
        }
        GlobalTransactionScanner.setBeanFactory((ConfigurableListableBeanFactory)beanFactory);
        GlobalTransactionScanner.addScannerCheckers((Collection)EnhancedServiceLoader.loadAll(ScannerChecker.class));
        GlobalTransactionScanner.addScannerCheckers(scannerCheckers);
        GlobalTransactionScanner.addScannablePackages((String[])seataProperties.getScanPackages());
        GlobalTransactionScanner.addScannerExcludeBeanNames((String[])seataProperties.getExcludesForScanning());
        GlobalTransactionScanner.setAccessKey((String)seataProperties.getAccessKey());
        GlobalTransactionScanner.setSecretKey((String)seataProperties.getSecretKey());
        return new GlobalTransactionScanner(seataProperties.getApplicationId(), seataProperties.getTxServiceGroup(), failureHandler);
    }
}

