/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import io.swagger.models.parameters.CookieParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.parameters.SerializableParameter;
import io.swagger.models.properties.Property;
import java.util.Map;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.service.AllowableListValues;
import springfox.documentation.swagger2.mappers.Properties;
import springfox.documentation.swagger2.mappers.SerializableParameterFactory;

public class SerializableParameterFactories {
    public static final Map<String, SerializableParameterFactory> factory = ImmutableMap.builder().put((Object)"header", (Object)new HeaderSerializableParameterFactory()).put((Object)"form", (Object)new FormSerializableParameterFactory()).put((Object)"path", (Object)new PathSerializableParameterFactory()).put((Object)"query", (Object)new QuerySerializableParameterFactory()).put((Object)"cookie", (Object)new CookieSerializableParameterFactory()).build();

    private SerializableParameterFactories() {
        throw new UnsupportedOperationException();
    }

    static Optional<Parameter> create(springfox.documentation.service.Parameter source) {
        SerializableParameterFactory factory = (SerializableParameterFactory)Functions.forMap(SerializableParameterFactories.factory, (Object)new NullSerializableParameterFactory()).apply((Object)source.getParamType().toLowerCase());
        SerializableParameter toReturn = factory.create(source);
        if (toReturn == null) {
            return Optional.absent();
        }
        ModelRef paramModel = source.getModelRef();
        toReturn.setName(source.getName());
        toReturn.setDescription(source.getDescription());
        toReturn.setAccess(source.getParamAccess());
        toReturn.setRequired(source.isRequired().booleanValue());
        if (paramModel.isCollection()) {
            toReturn.setCollectionFormat("csv");
            toReturn.setType("array");
            toReturn.setItems(Properties.property(paramModel.getItemType()));
        } else {
            Property property = Properties.property(paramModel.getType());
            toReturn.setType(property.getType());
            toReturn.setFormat(property.getFormat());
        }
        SerializableParameterFactories.maybeAddAlllowableValues(source, toReturn);
        return Optional.of((Object)toReturn);
    }

    private static void maybeAddAlllowableValues(springfox.documentation.service.Parameter source, SerializableParameter toReturn) {
        if (source.getAllowableValues() instanceof AllowableListValues) {
            AllowableListValues allowableValues = (AllowableListValues)source.getAllowableValues();
            toReturn.setEnum(allowableValues.getValues());
        }
    }

    static class NullSerializableParameterFactory
    implements SerializableParameterFactory {
        NullSerializableParameterFactory() {
        }

        @Override
        public SerializableParameter create(springfox.documentation.service.Parameter source) {
            return null;
        }
    }

    static class QuerySerializableParameterFactory
    implements SerializableParameterFactory {
        QuerySerializableParameterFactory() {
        }

        @Override
        public SerializableParameter create(springfox.documentation.service.Parameter source) {
            QueryParameter param = new QueryParameter();
            param.setDefaultValue(source.getDefaultValue());
            return param;
        }
    }

    static class PathSerializableParameterFactory
    implements SerializableParameterFactory {
        PathSerializableParameterFactory() {
        }

        @Override
        public SerializableParameter create(springfox.documentation.service.Parameter source) {
            PathParameter param = new PathParameter();
            param.setDefaultValue(source.getDefaultValue());
            return param;
        }
    }

    static class HeaderSerializableParameterFactory
    implements SerializableParameterFactory {
        HeaderSerializableParameterFactory() {
        }

        @Override
        public SerializableParameter create(springfox.documentation.service.Parameter source) {
            HeaderParameter param = new HeaderParameter();
            param.setDefaultValue(source.getDefaultValue());
            return param;
        }
    }

    static class FormSerializableParameterFactory
    implements SerializableParameterFactory {
        FormSerializableParameterFactory() {
        }

        @Override
        public SerializableParameter create(springfox.documentation.service.Parameter source) {
            FormParameter param = new FormParameter();
            param.setDefaultValue(source.getDefaultValue());
            return param;
        }
    }

    static class CookieSerializableParameterFactory
    implements SerializableParameterFactory {
        CookieSerializableParameterFactory() {
        }

        @Override
        public SerializableParameter create(springfox.documentation.service.Parameter source) {
            CookieParameter param = new CookieParameter();
            param.setDefaultValue(source.getDefaultValue());
            return param;
        }
    }
}

