/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt;

import io.netty.handler.codec.mqtt.MqttProperties;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Base64;
import java.util.List;

@DataObject
public class MqttWill {
    private final boolean isWillFlag;
    private final String willTopic;
    private final Buffer willMessage;
    private final int willQos;
    private final boolean isWillRetain;
    private final MqttProperties willProperties;

    public MqttWill(boolean isWillFlag, String willTopic, Buffer willMessage, int willQos, boolean isWillRetain, MqttProperties willProperties) {
        this.isWillFlag = isWillFlag;
        this.willTopic = willTopic;
        this.willMessage = willMessage;
        this.willQos = willQos;
        this.isWillRetain = isWillRetain;
        this.willProperties = willProperties;
    }

    public MqttWill(JsonObject json) {
        this.isWillFlag = json.getBoolean("isWillFlag");
        this.willTopic = json.getString("willTopic");
        this.willMessage = json.getBuffer("willMessage");
        this.willQos = json.getInteger("willQos");
        this.isWillRetain = json.getBoolean("isWillRetain");
        this.willProperties = MqttWill.propertiesFromJson(json.getJsonArray("willProperties"));
    }

    public boolean isWillFlag() {
        return this.isWillFlag;
    }

    public String getWillTopic() {
        return this.willTopic;
    }

    public Buffer getWillMessage() {
        return this.willMessage;
    }

    public byte[] getWillMessageBytes() {
        return this.willMessage != null ? this.willMessage.getBytes() : null;
    }

    public int getWillQos() {
        return this.willQos;
    }

    public boolean isWillRetain() {
        return this.isWillRetain;
    }

    public MqttProperties getWillProperties() {
        return this.willProperties;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.put("isWillFlag", (Object)this.isWillFlag);
        json.put("willTopic", (Object)this.willTopic);
        json.put("willMessage", (Object)this.willMessage);
        json.put("willQos", (Object)this.willQos);
        json.put("isWillRetain", (Object)this.isWillRetain);
        json.put("willProperties", (Object)MqttWill.propertiesToJson(this.willProperties));
        return json;
    }

    public static JsonArray propertiesToJson(MqttProperties properties) {
        JsonArray array = new JsonArray();
        for (MqttProperties.MqttProperty prop : properties.listAll()) {
            array.add((Object)MqttWill.propertyToJson(prop));
        }
        return array;
    }

    public static JsonObject propertyToJson(MqttProperties.MqttProperty<?> prop) {
        JsonObject obj = new JsonObject();
        if (prop instanceof MqttProperties.StringProperty || prop instanceof MqttProperties.IntegerProperty) {
            obj.put("id", (Object)prop.propertyId());
            obj.put("val", prop.value());
        } else if (prop instanceof MqttProperties.BinaryProperty) {
            obj.put("id", (Object)prop.propertyId());
            String value = Base64.getEncoder().encodeToString((byte[])((MqttProperties.BinaryProperty)prop).value());
            obj.put("val", (Object)value);
        } else if (prop instanceof MqttProperties.UserProperties) {
            for (MqttProperties.StringPair kv : (List)((MqttProperties.UserProperties)prop).value()) {
                obj.put("id", (Object)prop.propertyId());
                obj.put("key", (Object)kv.key);
                obj.put("val", (Object)kv.value);
            }
        }
        return obj;
    }

    public static MqttProperties propertiesFromJson(JsonArray array) {
        MqttProperties props = new MqttProperties();
        for (Object item : array) {
            props.add(MqttWill.propertyFromJson((JsonObject)item));
        }
        return props;
    }

    public static MqttProperties.MqttProperty<?> propertyFromJson(JsonObject obj) {
        int id = obj.getInteger("id");
        MqttProperties.MqttPropertyType propType = MqttProperties.MqttPropertyType.valueOf((int)id);
        switch (propType) {
            case PAYLOAD_FORMAT_INDICATOR: 
            case REQUEST_PROBLEM_INFORMATION: 
            case REQUEST_RESPONSE_INFORMATION: 
            case MAXIMUM_QOS: 
            case RETAIN_AVAILABLE: 
            case WILDCARD_SUBSCRIPTION_AVAILABLE: 
            case SUBSCRIPTION_IDENTIFIER_AVAILABLE: 
            case SHARED_SUBSCRIPTION_AVAILABLE: 
            case SERVER_KEEP_ALIVE: 
            case RECEIVE_MAXIMUM: 
            case TOPIC_ALIAS_MAXIMUM: 
            case TOPIC_ALIAS: 
            case PUBLICATION_EXPIRY_INTERVAL: 
            case SESSION_EXPIRY_INTERVAL: 
            case WILL_DELAY_INTERVAL: 
            case MAXIMUM_PACKET_SIZE: 
            case SUBSCRIPTION_IDENTIFIER: {
                return new MqttProperties.IntegerProperty(id, obj.getInteger("val"));
            }
            case CONTENT_TYPE: 
            case RESPONSE_TOPIC: 
            case ASSIGNED_CLIENT_IDENTIFIER: 
            case AUTHENTICATION_METHOD: 
            case RESPONSE_INFORMATION: 
            case SERVER_REFERENCE: 
            case REASON_STRING: {
                return new MqttProperties.StringProperty(id, obj.getString("val"));
            }
            case CORRELATION_DATA: 
            case AUTHENTICATION_DATA: {
                return new MqttProperties.BinaryProperty(id, Base64.getDecoder().decode(obj.getString("val")));
            }
            case USER_PROPERTY: {
                String key = obj.getString("key");
                return new MqttProperties.UserProperty(key, obj.getString("val"));
            }
        }
        throw new IllegalArgumentException("Unsupported property type: " + propType);
    }
}

