/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mysqlclient.impl.codec.ExtendedQueryCommandBaseCodec;
import io.vertx.mysqlclient.impl.codec.MySQLEncoder;
import io.vertx.mysqlclient.impl.codec.MySQLPreparedStatement;
import io.vertx.mysqlclient.impl.codec.RowResultDecoder;
import io.vertx.mysqlclient.impl.datatype.DataType;
import io.vertx.mysqlclient.impl.datatype.DataTypeCodec;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.command.CommandResponse;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;

class ExtendedQueryCommandCodec<R>
extends ExtendedQueryCommandBaseCodec<R, ExtendedQueryCommand<R>> {
    ExtendedQueryCommandCodec(ExtendedQueryCommand<R> cmd) {
        super(cmd);
        if (cmd.fetch() > 0 && this.statement.isCursorOpen) {
            this.columnDefinitions = this.statement.rowDesc.columnDefinitions();
        }
    }

    @Override
    void encode(MySQLEncoder encoder) {
        super.encode(encoder);
        if (this.statement.isCursorOpen) {
            if (this.decoder == null) {
                this.decoder = new RowResultDecoder(((ExtendedQueryCommand)this.cmd).collector(), this.statement.rowDesc);
            }
            this.sendStatementFetchCommand(this.statement.statementId, ((ExtendedQueryCommand)this.cmd).fetch());
        } else {
            Tuple params = ((ExtendedQueryCommand)this.cmd).params();
            String bindMsg = this.statement.bindParameters(params);
            if (bindMsg != null) {
                this.completionHandler.handle((Object)CommandResponse.failure((String)bindMsg));
                return;
            }
            if (((ExtendedQueryCommand)this.cmd).fetch() > 0) {
                this.sendStatementExecuteCommand(this.statement, true, params, (byte)1);
            } else {
                this.sendStatementExecuteCommand(this.statement, this.statement.sendTypesToServer(), params, (byte)0);
            }
        }
    }

    @Override
    void decodePayload(ByteBuf payload, int payloadLength) {
        block11: {
            block12: {
                block10: {
                    if (!this.statement.isCursorOpen) break block10;
                    short first = payload.getUnsignedByte(payload.readerIndex());
                    if (first == 255) {
                        this.handleErrorPacketPayload(payload);
                    } else {
                        this.handleRows(payload, payloadLength);
                    }
                    break block11;
                }
                if (((ExtendedQueryCommand)this.cmd).fetch() <= 0) break block12;
                switch (this.commandHandlerState) {
                    case INIT: {
                        short first = payload.getUnsignedByte(payload.readerIndex());
                        if (first == 255) {
                            this.handleErrorPacketPayload(payload);
                        } else {
                            this.handleResultsetColumnCountPacketBody(payload);
                        }
                        break block11;
                    }
                    case HANDLING_COLUMN_DEFINITION: {
                        this.handleResultsetColumnDefinitions(payload);
                        break block11;
                    }
                    case COLUMN_DEFINITIONS_DECODING_COMPLETED: {
                        this.skipEofPacketIfNeeded(payload);
                    }
                    case HANDLING_ROW_DATA_OR_END_PACKET: {
                        this.handleResultsetColumnDefinitionsDecodingCompleted();
                        this.sequenceId = 0;
                        this.statement.isCursorOpen = true;
                        this.sendStatementFetchCommand(this.statement.statementId, ((ExtendedQueryCommand)this.cmd).fetch());
                        break block11;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected state for decoding COM_STMT_EXECUTE response with cursor opening");
                    }
                }
            }
            super.decodePayload(payload, payloadLength);
        }
    }

    private void sendStatementExecuteCommand(MySQLPreparedStatement statement, boolean sendTypesToServer, Tuple params, byte cursorType) {
        ByteBuf packet = this.allocateBuffer();
        int packetStartIdx = packet.writerIndex();
        packet.writeMediumLE(0);
        packet.writeByte(this.sequenceId);
        packet.writeByte(23);
        packet.writeIntLE((int)statement.statementId);
        packet.writeByte((int)cursorType);
        packet.writeIntLE(1);
        int numOfParams = statement.bindingTypes().length;
        int bitmapLength = (numOfParams + 7) / 8;
        byte[] nullBitmap = new byte[bitmapLength];
        int pos = packet.writerIndex();
        if (numOfParams > 0) {
            packet.writeBytes(nullBitmap);
            packet.writeBoolean(sendTypesToServer);
            if (sendTypesToServer) {
                for (DataType bindingType : statement.bindingTypes()) {
                    packet.writeByte(bindingType.id);
                    packet.writeByte(0);
                }
            }
            for (int i = 0; i < numOfParams; ++i) {
                Object value = params.getValue(i);
                if (value != null) {
                    DataTypeCodec.encodeBinary(statement.bindingTypes()[i], value, this.encoder.encodingCharset, packet);
                    continue;
                }
                int n = i / 8;
                nullBitmap[n] = (byte)(nullBitmap[n] | 1 << (i & 7));
            }
            packet.setBytes(pos, nullBitmap);
        }
        int payloadLength = packet.writerIndex() - packetStartIdx - 4;
        packet.setMediumLE(packetStartIdx, payloadLength);
        this.sendPacket(packet, payloadLength);
    }

    private void sendStatementFetchCommand(long statementId, int count) {
        ByteBuf packet = this.allocateBuffer();
        int packetStartIdx = packet.writerIndex();
        packet.writeMediumLE(0);
        packet.writeByte(this.sequenceId);
        packet.writeByte(28);
        packet.writeIntLE((int)statementId);
        packet.writeIntLE(count);
        int lenOfPayload = packet.writerIndex() - packetStartIdx - 4;
        packet.setMediumLE(packetStartIdx, lenOfPayload);
        this.encoder.chctx.writeAndFlush((Object)packet, this.encoder.chctx.voidPromise());
    }
}

