/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.provider;

import com.google.common.base.Strings;
import java.util.Optional;
import me.ahoo.cosid.CosIdException;
import me.ahoo.cosid.IdConverter;
import me.ahoo.cosid.IdGenerator;
import me.ahoo.cosid.provider.DefaultIdGeneratorProvider;
import me.ahoo.cosid.provider.NotFoundIdGeneratorException;
import me.ahoo.cosid.segment.SegmentId;
import me.ahoo.cosid.snowflake.SnowflakeFriendlyId;
import me.ahoo.cosid.snowflake.SnowflakeId;

public final class LazyIdGenerator
implements IdGenerator {
    private final String generatorName;
    private IdGenerator lazyIdGen;

    public LazyIdGenerator(String generatorName) {
        this.generatorName = generatorName;
    }

    public String getGeneratorName() {
        return this.generatorName;
    }

    public IdGenerator tryGet(boolean required) {
        if (this.lazyIdGen != null) {
            return this.lazyIdGen;
        }
        String idName = this.getGeneratorName();
        Optional<IdGenerator> idGeneratorOp = DefaultIdGeneratorProvider.INSTANCE.get(idName);
        if (idGeneratorOp.isPresent()) {
            this.lazyIdGen = idGeneratorOp.get();
            return this.lazyIdGen;
        }
        if (required) {
            throw new NotFoundIdGeneratorException(idName);
        }
        return null;
    }

    public SnowflakeId asSnowflakeId(boolean required) {
        IdGenerator idGenerator = this.tryGet(required);
        if (idGenerator instanceof SnowflakeId) {
            return (SnowflakeId)idGenerator;
        }
        throw new CosIdException(Strings.lenientFormat((String)"IdGenerator:[%s] is not instanceof SnowflakeId!", (Object[])new Object[]{this.generatorName}));
    }

    public SnowflakeFriendlyId asFriendlyId(boolean required) {
        IdGenerator idGenerator = this.tryGet(required);
        if (idGenerator instanceof SnowflakeFriendlyId) {
            return (SnowflakeFriendlyId)idGenerator;
        }
        throw new CosIdException(Strings.lenientFormat((String)"IdGenerator:[%s] is not instanceof SnowflakeFriendlyId!", (Object[])new Object[]{this.generatorName}));
    }

    public SegmentId asSegmentId(boolean required) {
        IdGenerator idGenerator = this.tryGet(required);
        if (idGenerator instanceof SegmentId) {
            return (SegmentId)idGenerator;
        }
        throw new CosIdException(Strings.lenientFormat((String)"IdGenerator:[%s] is not instanceof SegmentId!", (Object[])new Object[]{this.generatorName}));
    }

    @Override
    public long generate() {
        return this.tryGet(true).generate();
    }

    @Override
    public IdConverter idConverter() {
        return this.tryGet(true).idConverter();
    }
}

