/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.segment;

import java.util.function.Function;
import javax.annotation.concurrent.GuardedBy;
import me.ahoo.cosid.segment.DefaultIdSegment;
import me.ahoo.cosid.segment.IdSegment;
import me.ahoo.cosid.segment.NextIdSegmentExpiredException;

public class IdSegmentChain
implements IdSegment {
    public static final int ROOT_VERSION = -1;
    public static final IdSegmentChain NOT_SET = null;
    private final long version;
    private final IdSegment idSegment;
    @GuardedBy(value="this")
    private volatile IdSegmentChain next;

    public IdSegmentChain(IdSegmentChain previousChain, IdSegment idSegment) {
        this(previousChain.getVersion() + 1L, idSegment);
    }

    public IdSegmentChain(long version, IdSegment idSegment) {
        this.version = version;
        this.idSegment = idSegment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean trySetNext(Function<IdSegmentChain, IdSegmentChain> idSegmentChainSupplier) throws NextIdSegmentExpiredException {
        if (NOT_SET != this.next) {
            return false;
        }
        IdSegmentChain idSegmentChain = this;
        synchronized (idSegmentChain) {
            if (NOT_SET != this.next) {
                return false;
            }
            IdSegmentChain nextIdSegmentChain = idSegmentChainSupplier.apply(this);
            this.setNext(nextIdSegmentChain);
            return true;
        }
    }

    public void setNext(IdSegmentChain nextIdSegmentChain) {
        this.ensureNextIdSegment(nextIdSegmentChain);
        this.next = nextIdSegmentChain;
    }

    public IdSegmentChain ensureSetNext(Function<IdSegmentChain, IdSegmentChain> idSegmentChainSupplier) throws NextIdSegmentExpiredException {
        IdSegmentChain currentChain = this;
        while (!currentChain.trySetNext(idSegmentChainSupplier)) {
            currentChain = currentChain.getNext();
        }
        return currentChain;
    }

    public IdSegmentChain getNext() {
        return this.next;
    }

    public IdSegment getIdSegment() {
        return this.idSegment;
    }

    public long getVersion() {
        return this.version;
    }

    public int gap(IdSegmentChain end, long step) {
        return (int)((end.getMaxId() - this.getSequence()) / step);
    }

    public static IdSegmentChain newRoot() {
        return new IdSegmentChain(-1L, (IdSegment)DefaultIdSegment.OVERFLOW);
    }

    @Override
    public long getFetchTime() {
        return this.idSegment.getFetchTime();
    }

    @Override
    public long getMaxId() {
        return this.idSegment.getMaxId();
    }

    @Override
    public long getOffset() {
        return this.idSegment.getOffset();
    }

    @Override
    public long getSequence() {
        return this.idSegment.getSequence();
    }

    @Override
    public long getStep() {
        return this.idSegment.getStep();
    }

    @Override
    public long incrementAndGet() {
        return this.idSegment.incrementAndGet();
    }

    public String toString() {
        return "IdSegmentChain{version=" + this.version + ", idSegment=" + this.idSegment + '}';
    }
}

