/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.sharding;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;

public class IntervalStep {
    public static final int DEFAULT_AMOUNT = 1;
    private final ChronoUnit unit;
    private final int amount;

    public IntervalStep(ChronoUnit unit, int amount) {
        this.unit = unit;
        this.amount = amount;
    }

    public ChronoUnit getUnit() {
        return this.unit;
    }

    public int getAmount() {
        return this.amount;
    }

    public LocalDateTime next(LocalDateTime previous) {
        return previous.plus(this.amount, this.unit);
    }

    public LocalDateTime floorUnit(LocalDateTime time) {
        switch (this.unit) {
            case YEARS: {
                return LocalDateTime.of(time.getYear(), 1, 1, 0, 0);
            }
            case MONTHS: {
                return LocalDateTime.of(time.getYear(), time.getMonthValue(), 1, 0, 0);
            }
            case DAYS: {
                return LocalDateTime.of(time.getYear(), time.getMonthValue(), time.getDayOfMonth(), 0, 0);
            }
            case HOURS: {
                return LocalDateTime.of(time.getYear(), time.getMonthValue(), time.getDayOfMonth(), time.getHour(), 0);
            }
            case MINUTES: {
                return LocalDateTime.of(time.getYear(), time.getMonthValue(), time.getDayOfMonth(), time.getHour(), time.getMinute());
            }
            case SECONDS: {
                return LocalDateTime.of(time.getYear(), time.getMonthValue(), time.getDayOfMonth(), time.getHour(), time.getMinute(), time.getSecond());
            }
        }
        throw new IllegalStateException("Unexpected value: " + this.unit);
    }

    public int offsetUnit(LocalDateTime start, LocalDateTime time) {
        return this.getDiffUnit(start, time) / this.amount;
    }

    private int getDiffUnit(LocalDateTime startInterval, LocalDateTime time) {
        switch (this.unit) {
            case YEARS: {
                return this.getDiffYear(startInterval, time);
            }
            case MONTHS: {
                return this.getDiffYearMonth(startInterval, time);
            }
            case DAYS: {
                return this.getDiffYearMonthDay(startInterval, time);
            }
            case HOURS: {
                return this.getDiffYearMonthDay(startInterval, time) * 24;
            }
            case MINUTES: {
                return this.getDiffYearMonthDay(startInterval, time) * 24 * 60;
            }
            case SECONDS: {
                return this.getDiffYearMonthDay(startInterval, time) * 24 * 60 * 60;
            }
        }
        throw new IllegalStateException("Unexpected value: " + this.unit);
    }

    private int getDiffYearMonthDay(LocalDateTime startInterval, LocalDateTime time) {
        return (int)(time.toLocalDate().toEpochDay() - startInterval.toLocalDate().toEpochDay());
    }

    private int getDiffYearMonth(LocalDateTime startInterval, LocalDateTime time) {
        return this.getDiffYear(startInterval, time) * 12 + (time.getMonthValue() - startInterval.getMonthValue());
    }

    private int getDiffYear(LocalDateTime startInterval, LocalDateTime time) {
        return time.getYear() - startInterval.getYear();
    }

    public static IntervalStep of(ChronoUnit unit) {
        return new IntervalStep(unit, 1);
    }

    public static IntervalStep of(ChronoUnit unit, int amount) {
        return new IntervalStep(unit, amount);
    }
}

