/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.snowflake;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import me.ahoo.cosid.snowflake.SnowflakeId;
import me.ahoo.cosid.snowflake.SnowflakeIdStateParser;

public class MillisecondSnowflakeIdStateParser
extends SnowflakeIdStateParser {
    public static final SnowflakeIdStateParser INSTANCE = new MillisecondSnowflakeIdStateParser(1577203200000L, 41, 10, 12);
    public static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4).appendValue(ChronoField.MONTH_OF_YEAR, 2).appendValue(ChronoField.DAY_OF_MONTH, 2).appendValue(ChronoField.HOUR_OF_DAY, 2).appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendValue(ChronoField.MILLI_OF_SECOND, 3).toFormatter();

    public MillisecondSnowflakeIdStateParser(long epoch, int timestampBit, int machineBit, int sequenceBit) {
        this(epoch, timestampBit, machineBit, sequenceBit, ZoneId.systemDefault());
    }

    public MillisecondSnowflakeIdStateParser(long epoch, int timestampBit, int machineBit, int sequenceBit, ZoneId zoneId) {
        super(epoch, timestampBit, machineBit, sequenceBit, zoneId);
    }

    @Override
    protected DateTimeFormatter getDateTimeFormatter() {
        return DATE_TIME_FORMATTER;
    }

    @Override
    protected LocalDateTime getTimestamp(long diffTime) {
        return Instant.ofEpochMilli(this.epoch + diffTime).atZone(this.getZoneId()).toLocalDateTime();
    }

    @Override
    protected long getDiffTime(LocalDateTime timestamp) {
        return ZonedDateTime.of(timestamp, this.getZoneId()).toInstant().toEpochMilli() - this.epoch;
    }

    public static MillisecondSnowflakeIdStateParser of(SnowflakeId snowflakeId) {
        return MillisecondSnowflakeIdStateParser.of(snowflakeId, ZoneId.systemDefault());
    }

    public static MillisecondSnowflakeIdStateParser of(SnowflakeId snowflakeId, ZoneId zoneId) {
        return new MillisecondSnowflakeIdStateParser(snowflakeId.getEpoch(), snowflakeId.getTimestampBit(), snowflakeId.getMachineBit(), snowflakeId.getSequenceBit(), zoneId);
    }
}

