/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.util;

import java.time.Duration;
import java.util.concurrent.locks.LockSupport;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface Clock {
    public static final Clock CACHE = new CacheClock();
    public static final Clock SYSTEM = new SystemClock();

    public long secondTime();

    public static long getSystemSecondTime() {
        return System.currentTimeMillis() / 1000L;
    }

    public static class CacheClock
    implements Clock,
    Runnable {
        public static final long ONE_SECOND_PERIOD = Duration.ofSeconds(1L).toNanos();
        private final Thread thread;
        private volatile long lastTime = Clock.getSystemSecondTime();

        public CacheClock() {
            this.thread = new Thread(this);
            this.thread.setName("CosId-CacheClock");
            this.thread.setDaemon(true);
            this.thread.start();
        }

        @Override
        public long secondTime() {
            return this.lastTime;
        }

        @Override
        public void run() {
            while (!this.thread.isInterrupted()) {
                this.lastTime = Clock.getSystemSecondTime();
                LockSupport.parkNanos(this, ONE_SECOND_PERIOD);
            }
        }
    }

    public static class SystemClock
    implements Clock {
        @Override
        public long secondTime() {
            return Clock.getSystemSecondTime();
        }
    }
}

