/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.core;

import java.time.Instant;
import java.util.Objects;
import net.javacrumbs.shedlock.core.ClockProvider;
import org.jetbrains.annotations.NotNull;

public class LockConfiguration {
    private final String name;
    private final Instant lockAtMostUntil;
    private final Instant lockAtLeastUntil;

    public LockConfiguration(@NotNull String name, @NotNull Instant lockAtMostUntil) {
        this(name, lockAtMostUntil, ClockProvider.now());
    }

    public LockConfiguration(@NotNull String name, @NotNull Instant lockAtMostUntil, @NotNull Instant lockAtLeastUntil) {
        this.name = Objects.requireNonNull(name);
        this.lockAtMostUntil = Objects.requireNonNull(lockAtMostUntil);
        this.lockAtLeastUntil = Objects.requireNonNull(lockAtLeastUntil);
        if (lockAtLeastUntil.isAfter(lockAtMostUntil)) {
            throw new IllegalArgumentException("lockAtMostUntil is before lockAtLeastUntil for lock '" + name + "'.");
        }
        if (lockAtMostUntil.isBefore(ClockProvider.now())) {
            throw new IllegalArgumentException("lockAtMostUntil is in the past for lock '" + name + "'.");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("lock name can not be empty");
        }
    }

    public String getName() {
        return this.name;
    }

    public Instant getLockAtMostUntil() {
        return this.lockAtMostUntil;
    }

    public Instant getLockAtLeastUntil() {
        return this.lockAtLeastUntil;
    }

    public Instant getUnlockTime() {
        Instant now = ClockProvider.now();
        return this.lockAtLeastUntil.isAfter(now) ? this.lockAtLeastUntil : now;
    }

    public String toString() {
        return "LockConfiguration{name='" + this.name + '\'' + ", lockAtMostUntil=" + this.lockAtMostUntil + ", lockAtLeastUntil=" + this.lockAtLeastUntil + '}';
    }
}

