/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.support;

import java.util.Optional;
import net.javacrumbs.shedlock.core.AbstractSimpleLock;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.LockRecordRegistry;
import net.javacrumbs.shedlock.support.StorageAccessor;
import org.jetbrains.annotations.NotNull;

public class StorageBasedLockProvider
implements LockProvider {
    @NotNull
    private final StorageAccessor storageAccessor;
    private final LockRecordRegistry lockRecordRegistry = new LockRecordRegistry();

    protected StorageBasedLockProvider(@NotNull StorageAccessor storageAccessor) {
        this.storageAccessor = storageAccessor;
    }

    public void clearCache() {
        this.lockRecordRegistry.clear();
    }

    @Override
    @NotNull
    public Optional<SimpleLock> lock(@NotNull LockConfiguration lockConfiguration) {
        boolean lockObtained = this.doLock(lockConfiguration);
        if (lockObtained) {
            return Optional.of(new StorageLock(lockConfiguration, this.storageAccessor));
        }
        return Optional.empty();
    }

    protected boolean doLock(LockConfiguration lockConfiguration) {
        String name = lockConfiguration.getName();
        if (!this.lockRecordRegistry.lockRecordRecentlyCreated(name)) {
            if (this.storageAccessor.insertRecord(lockConfiguration)) {
                this.lockRecordRegistry.addLockRecord(name);
                return true;
            }
            this.lockRecordRegistry.addLockRecord(name);
        }
        return this.storageAccessor.updateRecord(lockConfiguration);
    }

    private static class StorageLock
    extends AbstractSimpleLock {
        private final StorageAccessor storageAccessor;

        StorageLock(LockConfiguration lockConfiguration, StorageAccessor storageAccessor) {
            super(lockConfiguration);
            this.storageAccessor = storageAccessor;
        }

        @Override
        public void doUnlock() {
            this.storageAccessor.unlock(this.lockConfiguration);
        }

        @Override
        public Optional<SimpleLock> doExtend(LockConfiguration newConfig) {
            if (this.storageAccessor.extend(newConfig)) {
                return Optional.of(new StorageLock(newConfig, this.storageAccessor));
            }
            return Optional.empty();
        }
    }
}

