/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.support;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import org.jetbrains.annotations.NotNull;

public final class Utils {
    private static final DateTimeFormatter formatter = new DateTimeFormatterBuilder().parseCaseInsensitive().appendInstant(3).toFormatter();
    private static final String hostname = Utils.initHostname();

    private Utils() {
    }

    @NotNull
    public static String getHostname() {
        return hostname;
    }

    public static String toIsoString(@NotNull Instant instant) {
        OffsetDateTime utc = instant.atOffset(ZoneOffset.UTC);
        return formatter.format(utc);
    }

    @NotNull
    private static String initHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "unknown";
        }
    }
}

