/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import nl.basjes.parse.useragent.analyze.Matcher;
import nl.basjes.parse.useragent.analyze.NumberRangeList;
import nl.basjes.parse.useragent.analyze.NumberRangeVisitor;
import nl.basjes.parse.useragent.analyze.WordRangeVisitor;
import nl.basjes.parse.useragent.analyze.treewalker.TreeExpressionEvaluator;
import nl.basjes.parse.useragent.parser.UserAgentTreeWalkerBaseVisitor;
import nl.basjes.parse.useragent.parser.UserAgentTreeWalkerLexer;
import nl.basjes.parse.useragent.parser.UserAgentTreeWalkerParser;
import nl.basjes.shaded.org.antlr.v4.runtime.ANTLRErrorListener;
import nl.basjes.shaded.org.antlr.v4.runtime.ANTLRInputStream;
import nl.basjes.shaded.org.antlr.v4.runtime.CommonToken;
import nl.basjes.shaded.org.antlr.v4.runtime.CommonTokenStream;
import nl.basjes.shaded.org.antlr.v4.runtime.Parser;
import nl.basjes.shaded.org.antlr.v4.runtime.ParserRuleContext;
import nl.basjes.shaded.org.antlr.v4.runtime.RecognitionException;
import nl.basjes.shaded.org.antlr.v4.runtime.Recognizer;
import nl.basjes.shaded.org.antlr.v4.runtime.Token;
import nl.basjes.shaded.org.antlr.v4.runtime.atn.ATNConfigSet;
import nl.basjes.shaded.org.antlr.v4.runtime.dfa.DFA;
import nl.basjes.shaded.org.antlr.v4.runtime.tree.ParseTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MatcherAction
implements Serializable {
    private String matchExpression;
    private static final NumberRangeVisitor NUMBER_RANGE_VISITOR = new NumberRangeVisitor();
    private TreeExpressionEvaluator evaluator;
    private static final Logger LOG = LoggerFactory.getLogger(MatcherAction.class);
    private Matcher matcher;
    protected List<Match> matches;
    private boolean isFixedString;
    boolean verbose = false;
    private boolean verbosePermanent = false;
    private boolean verboseTemporary = false;

    TreeExpressionEvaluator getEvaluatorForUnitTesting() {
        return this.evaluator;
    }

    private void setVerbose(boolean newVerbose) {
        this.setVerbose(newVerbose, false);
    }

    public void setVerbose(boolean newVerbose, boolean temporary) {
        this.verbose = newVerbose;
        if (!temporary) {
            this.verbosePermanent = newVerbose;
        }
        this.verboseTemporary = temporary;
    }

    public String getMatchExpression() {
        return this.matchExpression;
    }

    void init(String newMatchExpression, Matcher newMatcher) {
        this.matcher = newMatcher;
        this.matches = new ArrayList<Match>(16);
        this.isFixedString = false;
        this.matchExpression = newMatchExpression;
        this.setVerbose(newMatcher.getVerbose());
        InitErrorListener errorListener = new InitErrorListener();
        ANTLRInputStream input = new ANTLRInputStream(this.matchExpression);
        UserAgentTreeWalkerLexer lexer = new UserAgentTreeWalkerLexer(input);
        lexer.addErrorListener(errorListener);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        UserAgentTreeWalkerParser parser = new UserAgentTreeWalkerParser(tokens);
        parser.addErrorListener(errorListener);
        ParserRuleContext requiredPattern = this.parseWalkerExpression(parser);
        if (requiredPattern == null) {
            throw new InvalidParserConfigurationException("NO pattern ?!?!?");
        }
        new UnQuoteValues().visit(requiredPattern);
        this.evaluator = new TreeExpressionEvaluator(requiredPattern, newMatcher.lookups, this.verbose);
        String fixedValue = this.evaluator.getFixedValue();
        if (fixedValue != null) {
            this.setFixedValue(fixedValue);
            this.isFixedString = true;
            return;
        }
        this.calculateInformPath("agent", requiredPattern);
    }

    protected abstract ParserRuleContext parseWalkerExpression(UserAgentTreeWalkerParser var1);

    protected abstract void setFixedValue(String var1);

    public void inform(String key, String value, ParseTree result) {
        this.matches.add(new Match(key, value, result));
        this.matcher.gotAStartingPoint();
    }

    protected abstract void inform(String var1, String var2);

    public boolean canPossiblyBeValid() {
        return this.evaluator.usesIsNull() || this.isFixedString || !this.matches.isEmpty();
    }

    public abstract boolean obtainResult(UserAgent var1);

    boolean isValidIsNull() {
        return this.matches.isEmpty() && this.evaluator.usesIsNull();
    }

    void processInformedMatches() {
        for (Match match : this.matches) {
            String matchedValue = this.evaluator.evaluate(match.result, match.key, match.value);
            if (matchedValue == null) continue;
            this.inform(match.key, matchedValue);
            break;
        }
    }

    private void calculateInformPath(String treeName, ParserRuleContext tree) {
        if (tree instanceof UserAgentTreeWalkerParser.MatcherRequireContext) {
            this.calculateInformPath(treeName, (UserAgentTreeWalkerParser.MatcherRequireContext)tree);
            return;
        }
        if (tree instanceof UserAgentTreeWalkerParser.MatcherContext) {
            this.calculateInformPath(treeName, (UserAgentTreeWalkerParser.MatcherContext)tree);
        }
    }

    private void calculateInformPath(String treeName, UserAgentTreeWalkerParser.MatcherRequireContext tree) {
        if (tree instanceof UserAgentTreeWalkerParser.MatcherBaseContext) {
            this.calculateInformPath(treeName, ((UserAgentTreeWalkerParser.MatcherBaseContext)tree).matcher());
            return;
        }
        if (tree instanceof UserAgentTreeWalkerParser.MatcherPathIsNullContext) {
            this.calculateInformPath(treeName, ((UserAgentTreeWalkerParser.MatcherPathIsNullContext)tree).matcher());
        }
    }

    private void calculateInformPath(String treeName, UserAgentTreeWalkerParser.MatcherContext tree) {
        if (tree instanceof UserAgentTreeWalkerParser.MatcherPathContext) {
            this.calculateInformPath(treeName, ((UserAgentTreeWalkerParser.MatcherPathContext)tree).basePath());
            return;
        }
        if (tree instanceof UserAgentTreeWalkerParser.MatcherCleanVersionContext) {
            this.calculateInformPath(treeName, ((UserAgentTreeWalkerParser.MatcherCleanVersionContext)tree).matcher());
            return;
        }
        if (tree instanceof UserAgentTreeWalkerParser.MatcherNormalizeBrandContext) {
            this.calculateInformPath(treeName, ((UserAgentTreeWalkerParser.MatcherNormalizeBrandContext)tree).matcher());
            return;
        }
        if (tree instanceof UserAgentTreeWalkerParser.MatcherPathLookupContext) {
            this.calculateInformPath(treeName, ((UserAgentTreeWalkerParser.MatcherPathLookupContext)tree).matcher());
            return;
        }
        if (tree instanceof UserAgentTreeWalkerParser.MatcherWordRangeContext) {
            this.calculateInformPath(treeName, ((UserAgentTreeWalkerParser.MatcherWordRangeContext)tree).matcher());
        }
    }

    private void calculateInformPath(String treeName, UserAgentTreeWalkerParser.BasePathContext tree) {
        if (tree instanceof UserAgentTreeWalkerParser.PathWalkContext) {
            this.calculateInformPath(treeName, ((UserAgentTreeWalkerParser.PathWalkContext)tree).nextStep);
        }
    }

    private void calculateInformPath(String treeName, UserAgentTreeWalkerParser.PathContext tree) {
        if (tree != null) {
            if (tree instanceof UserAgentTreeWalkerParser.StepDownContext) {
                this.calculateInformPath(treeName, (UserAgentTreeWalkerParser.StepDownContext)tree);
                return;
            }
            if (tree instanceof UserAgentTreeWalkerParser.StepEqualsValueContext) {
                this.calculateInformPath(treeName, (UserAgentTreeWalkerParser.StepEqualsValueContext)tree);
                return;
            }
            if (tree instanceof UserAgentTreeWalkerParser.StepWordRangeContext) {
                this.calculateInformPath(treeName, (UserAgentTreeWalkerParser.StepWordRangeContext)tree);
                return;
            }
        }
        this.matcher.informMeAbout(this, treeName);
    }

    private void calculateInformPath(String treeName, UserAgentTreeWalkerParser.StepDownContext tree) {
        if (treeName.length() == 0) {
            this.calculateInformPath(treeName + '.' + tree.name.getText(), tree.nextStep);
        } else {
            for (Integer number : (NumberRangeList)NUMBER_RANGE_VISITOR.visit(tree.numberRange())) {
                this.calculateInformPath(treeName + '.' + "(" + number + ")" + tree.name.getText(), tree.nextStep);
            }
        }
    }

    private void calculateInformPath(String treeName, UserAgentTreeWalkerParser.StepEqualsValueContext tree) {
        this.matcher.informMeAbout(this, treeName + "=\"" + tree.value.getText() + "\"");
    }

    private void calculateInformPath(String treeName, UserAgentTreeWalkerParser.StepWordRangeContext tree) {
        WordRangeVisitor.Range range = WordRangeVisitor.getRange(tree.wordRange());
        if (range.isRangeInHashMap()) {
            this.calculateInformPath(treeName + "[" + range.first + "-" + range.last + "]", tree.nextStep);
        } else {
            this.matcher.informMeAbout(this, treeName);
        }
    }

    public void reset() {
        if (!this.matches.isEmpty()) {
            this.matches.clear();
        }
        if (this.verboseTemporary) {
            this.verbose = this.verbosePermanent;
        }
    }

    public List<Match> getMatches() {
        return this.matches;
    }

    private static class UnQuoteValues
    extends UserAgentTreeWalkerBaseVisitor<Void> {
        private UnQuoteValues() {
        }

        private void unQuoteToken(Token token) {
            if (token instanceof CommonToken) {
                CommonToken commonToken = (CommonToken)token;
                commonToken.setStartIndex(commonToken.getStartIndex() + 1);
                commonToken.setStopIndex(commonToken.getStopIndex() - 1);
            }
        }

        @Override
        public Void visitMatcherPathLookup(UserAgentTreeWalkerParser.MatcherPathLookupContext ctx) {
            this.unQuoteToken(ctx.defaultValue);
            return (Void)super.visitMatcherPathLookup(ctx);
        }

        @Override
        public Void visitPathFixedValue(UserAgentTreeWalkerParser.PathFixedValueContext ctx) {
            this.unQuoteToken(ctx.value);
            return (Void)super.visitPathFixedValue(ctx);
        }

        @Override
        public Void visitStepEqualsValue(UserAgentTreeWalkerParser.StepEqualsValueContext ctx) {
            this.unQuoteToken(ctx.value);
            return (Void)super.visitStepEqualsValue(ctx);
        }

        @Override
        public Void visitStepNotEqualsValue(UserAgentTreeWalkerParser.StepNotEqualsValueContext ctx) {
            this.unQuoteToken(ctx.value);
            return (Void)super.visitStepNotEqualsValue(ctx);
        }

        @Override
        public Void visitStepStartsWithValue(UserAgentTreeWalkerParser.StepStartsWithValueContext ctx) {
            this.unQuoteToken(ctx.value);
            return (Void)super.visitStepStartsWithValue(ctx);
        }

        @Override
        public Void visitStepEndsWithValue(UserAgentTreeWalkerParser.StepEndsWithValueContext ctx) {
            this.unQuoteToken(ctx.value);
            return (Void)super.visitStepEndsWithValue(ctx);
        }

        @Override
        public Void visitStepContainsValue(UserAgentTreeWalkerParser.StepContainsValueContext ctx) {
            this.unQuoteToken(ctx.value);
            return (Void)super.visitStepContainsValue(ctx);
        }
    }

    class InitErrorListener
    implements ANTLRErrorListener {
        boolean hasAmbiguity;

        InitErrorListener() {
        }

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            LOG.error("Syntax error");
            LOG.error("Source : {}", (Object)MatcherAction.this.matchExpression);
            LOG.error("Message: {}", (Object)msg);
            System.exit(-1);
        }

        @Override
        public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
            this.hasAmbiguity = true;
        }

        @Override
        public void reportAttemptingFullContext(Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet conflictingAlts, ATNConfigSet configs) {
        }

        @Override
        public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
        }
    }

    public class Match {
        final String key;
        final String value;
        final ParseTree result;

        public Match(String key, String value, ParseTree result) {
            this.key = key;
            this.value = value;
            this.result = result;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public ParseTree getResult() {
            return this.result;
        }
    }
}

