/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.utils;

public final class VersionSplitter {
    private VersionSplitter() {
    }

    public static boolean isVersionSeparator(char c) {
        switch (c) {
            case '.': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    public static int findNextVersionStart(char[] chars, int offset) {
        for (int charNr = offset; charNr < chars.length; ++charNr) {
            char theChar = chars[charNr];
            if (VersionSplitter.isVersionSeparator(theChar)) continue;
            return charNr;
        }
        return -1;
    }

    public static int findVersionStart(char[] chars, int version) {
        if (version <= 0) {
            return -1;
        }
        int charNr = 0;
        boolean inVersion = false;
        int currentVersion = 0;
        for (char theChar : chars) {
            if (VersionSplitter.isVersionSeparator(theChar)) {
                if (inVersion) {
                    inVersion = false;
                }
            } else if (!inVersion) {
                inVersion = true;
                if (++currentVersion == version) {
                    return charNr;
                }
            }
            ++charNr;
        }
        return -1;
    }

    public static int findVersionEnd(char[] chars, int start) {
        for (int i = start; i < chars.length; ++i) {
            if (!VersionSplitter.isVersionSeparator(chars[i])) continue;
            return i;
        }
        return chars.length;
    }

    private static boolean looksLikeEmailOrWebaddress(String value) {
        return value.startsWith("www.") || value.startsWith("http") || value.contains("@") && value.contains(".");
    }

    public static String getSingleVersion(String value, int word) {
        if (value == null) {
            return null;
        }
        if (VersionSplitter.looksLikeEmailOrWebaddress(value)) {
            return word == 1 ? value : null;
        }
        char[] characters = value.toCharArray();
        int start = VersionSplitter.findVersionStart(characters, word);
        if (start == -1) {
            return null;
        }
        int end = VersionSplitter.findVersionEnd(characters, start);
        return value.substring(start, end);
    }

    public static String getFirstVersions(String value, int word) {
        if (value == null) {
            return null;
        }
        if (VersionSplitter.looksLikeEmailOrWebaddress(value)) {
            return word == 1 ? value : null;
        }
        char[] characters = value.toCharArray();
        int start = VersionSplitter.findVersionStart(characters, word);
        if (start == -1) {
            return null;
        }
        int end = VersionSplitter.findVersionEnd(characters, start);
        return value.substring(0, end);
    }

    public static String getVersionRange(String value, int firstVersion, int lastVersion) {
        if (value == null || lastVersion > 0 && lastVersion < firstVersion) {
            return null;
        }
        char[] characters = value.toCharArray();
        int firstCharOfFirstVersion = VersionSplitter.findVersionStart(characters, firstVersion);
        if (firstCharOfFirstVersion == -1) {
            return null;
        }
        if (lastVersion == -1) {
            return value.substring(firstCharOfFirstVersion, characters.length);
        }
        int firstCharOfLastWord = firstCharOfFirstVersion;
        if (lastVersion != firstVersion && (firstCharOfLastWord = VersionSplitter.findVersionStart(characters, lastVersion)) == -1) {
            return null;
        }
        int lastCharOfLastVersion = VersionSplitter.findVersionEnd(characters, firstCharOfLastWord);
        if (lastCharOfLastVersion == -1) {
            return null;
        }
        return value.substring(firstCharOfFirstVersion, lastCharOfLastVersion);
    }
}

