/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.support;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.rpc.cluster.support.ProviderURLMergeProcessor;

public class ClusterUtils {
    private ClusterUtils() {
    }

    public static URL mergeUrl(URL remoteUrl, Map<String, String> localMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        Map remoteMap = remoteUrl.getParameters();
        if (remoteMap != null && remoteMap.size() > 0) {
            map.putAll(remoteMap);
            map.remove("threadname");
            map.remove("default.threadname");
            map.remove("threadpool");
            map.remove("default.threadpool");
            map.remove("corethreads");
            map.remove("default.corethreads");
            map.remove("threads");
            map.remove("default.threads");
            map.remove("queues");
            map.remove("default.queues");
            map.remove("alive");
            map.remove("default.alive");
            map.remove("transporter");
            map.remove("default.transporter");
        }
        if (localMap != null && localMap.size() > 0) {
            HashMap<String, String> copyOfLocalMap = new HashMap<String, String>(localMap);
            if (map.containsKey("group")) {
                copyOfLocalMap.remove("group");
            }
            if (map.containsKey("version")) {
                copyOfLocalMap.remove("version");
            }
            if (map.containsKey("generic")) {
                copyOfLocalMap.remove("generic");
            }
            copyOfLocalMap.remove("release");
            copyOfLocalMap.remove("dubbo");
            copyOfLocalMap.remove("methods");
            copyOfLocalMap.remove("timestamp");
            copyOfLocalMap.remove("dubbo.tag");
            map.putAll(copyOfLocalMap);
            if (remoteMap != null) {
                map.put("remote.application", (String)remoteMap.get("application"));
                String remoteFilter = (String)remoteMap.get("reference.filter");
                String localFilter = (String)copyOfLocalMap.get("reference.filter");
                if (remoteFilter != null && remoteFilter.length() > 0 && localFilter != null && localFilter.length() > 0) {
                    map.put("reference.filter", remoteFilter + "," + localFilter);
                }
                String remoteListener = (String)remoteMap.get("invoker.listener");
                String localListener = (String)copyOfLocalMap.get("invoker.listener");
                if (remoteListener != null && remoteListener.length() > 0 && localListener != null && localListener.length() > 0) {
                    map.put("invoker.listener", remoteListener + "," + localListener);
                }
            }
        }
        return remoteUrl.clearParameters().addParameters(map);
    }

    public static URL mergeProviderUrl(URL remoteUrl, Map<String, String> localMap) {
        List providerURLMergeProcessors = ExtensionLoader.getExtensionLoader(ProviderURLMergeProcessor.class).getActivateExtension(remoteUrl, "upc");
        if (providerURLMergeProcessors != null && providerURLMergeProcessors.size() > 0) {
            for (ProviderURLMergeProcessor providerURLMergeProcessor : providerURLMergeProcessors) {
                if (!providerURLMergeProcessor.accept(remoteUrl, localMap)) continue;
                return providerURLMergeProcessor.mergeProviderUrl(remoteUrl, localMap);
            }
        }
        return ClusterUtils.mergeUrl(remoteUrl, localMap);
    }
}

